set foreign_key_checks=0;

ALTER TABLE `account_config` 
CHANGE COLUMN `createdBy` `createdBy` BIGINT(20) NOT NULL ,
CHANGE COLUMN `configName` `configName` VARCHAR(100) NOT NULL ,
CHANGE COLUMN `configDesc` `configDesc` VARCHAR(255) NOT NULL ,
CHANGE COLUMN `modeOfTransaction` `modeOfTransaction` VARCHAR(10) NULL DEFAULT NULL COMMENT 'RealTime/Batch' ,
CHANGE COLUMN `batchMode` `batchMode` VARCHAR(35) NULL DEFAULT NULL COMMENT 'Individual/Consolidate' ;


ALTER TABLE `account_config` 
ADD COLUMN `createdDate` TIMESTAMP NULL AFTER `createdBy`;



ALTER TABLE `account_config_batch_sch` 
DROP COLUMN `scheduleTime`;

ALTER TABLE `account_config_import_sch` 
DROP COLUMN `importTime`;

CREATE TABLE `accounting_year_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `accountingYearType` varchar(100) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefusersFK6765_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefusersFK6765` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
);

CREATE TABLE `accounting_year` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `accountingYearTypeId` bigint(20) DEFAULT NULL,
  `accountingYear` varchar(100) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `companyCode` varchar(100) DEFAULT NULL,
  `companyIp` varchar(255) DEFAULT NULL,
  `whetherCurrentYear` bit(1) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefaccountingyearType87_idx` (`accountingYearTypeId`),
  KEY `RefusersFK232_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefaccountingyearType87` FOREIGN KEY (`accountingYearTypeId`) REFERENCES `accounting_year_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefusersFK232` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
);


ALTER TABLE `iau_accounting` 
DROP COLUMN `companyCode`,
ADD COLUMN `accountingYearId` BIGINT(20) NULL AFTER `tillDate`;


ALTER TABLE `iau_accounting` 
ADD INDEX `Refaccountingyear34_idx` (`accountingYearId` ASC);
ALTER TABLE `iau_accounting` 
ADD CONSTRAINT `Refaccountingyear34`
  FOREIGN KEY (`accountingYearId`)
  REFERENCES `accounting_year` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


CREATE TABLE `control_account` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `accountConfigId` bigint(20) DEFAULT NULL,
  `iauId` bigint(20) DEFAULT NULL,
  `whetherDefaultControlAccount` bit(1) DEFAULT NULL,
  `controlAccountKey` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `RefaccountconfigFK1_idx` (`accountConfigId`),
  KEY `RefIauFK1_idx` (`iauId`),
  KEY `RefusersFK878_idx` (`lastUpdatedBy`),
  CONSTRAINT `RefaccountconfigFK1` FOREIGN KEY (`accountConfigId`) REFERENCES `account_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefIauFK1` FOREIGN KEY (`iauId`) REFERENCES `organization_units` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefusersFK878` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
);


 set foreign_key_checks=1; 
  
