set foreign_key_checks=0;
DROP TABLE IF Exists `config_control_account`;
CREATE TABLE `config_control_account` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `iauAccountingId` bigint(20) DEFAULT NULL,
  `controlAccountId` bigint(20) DEFAULT NULL,
  `configurationKey` varchar(255) DEFAULT NULL,
  `controlAccountMappingFor` varchar(255) DEFAULT NULL,
  `feeHeadId` bigint(20) DEFAULT NULL,
  `feePlanId` bigint(20) DEFAULT NULL,
  `feeStageHeadConfigId` bigint(20) DEFAULT NULL,
  `scholarshipId` bigint(20) DEFAULT NULL,
  `sponsorId` bigint(20) DEFAULT NULL,
  `depandantHeadId` bigint(20) DEFAULT NULL,
  `thirdPartyId` bigint(20) DEFAULT NULL,
  `discountCode` bigint(20) DEFAULT NULL,
  `debitNarration` varchar(255) DEFAULT NULL,
  `creditNarration` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refiau_accounting1491` (`iauAccountingId`),
  KEY `Refusers1492` (`lastUpdatedBy`),
  KEY `RefcontrolaccountFK23_idx` (`controlAccountId`),
  KEY `RefFeeHeadFK_idx` (`feeHeadId`),
  KEY `RefFeePlanFK_idx` (`feePlanId`),
  KEY `RefFeestageheadconfigFK_idx` (`feeStageHeadConfigId`),
  KEY `RefScholarshipFK_idx` (`scholarshipId`),
  KEY `RefSponsorFK_idx` (`sponsorId`),
  KEY `RefDependentFeeFK_idx` (`depandantHeadId`),
  KEY `RefThirdPartyFK_idx` (`thirdPartyId`),
  KEY `RefDiscountCode_idx` (`discountCode`),
  CONSTRAINT `RefDependentFeeFK` FOREIGN KEY (`depandantHeadId`) REFERENCES `fee_heads` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefThirdPartyFK` FOREIGN KEY (`thirdPartyId`) REFERENCES `fee_third_parties` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefDiscountCode` FOREIGN KEY (`discountCode`) REFERENCES `discount_code` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefcontrolaccountFK23` FOREIGN KEY (`controlAccountId`) REFERENCES `control_account` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefFeeHeadFK` FOREIGN KEY (`feeHeadId`) REFERENCES `fee_heads` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefFeePlanFK` FOREIGN KEY (`feePlanId`) REFERENCES `fee_plan` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefFeestageheadconfigFK` FOREIGN KEY (`feeStageHeadConfigId`) REFERENCES `fee_stage_head_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refiau_accounting1491` FOREIGN KEY (`iauAccountingId`) REFERENCES `iau_accounting` (`id`),
  CONSTRAINT `RefScholarshipFK` FOREIGN KEY (`scholarshipId`) REFERENCES `scholarship` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefSponsorFK` FOREIGN KEY (`sponsorId`) REFERENCES `sponsors` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refusers1492` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ;
set foreign_key_checks=1;

ALTER TABLE `account_config` 
CHANGE COLUMN `whetherBatch` `whetherBatch` BIT(1) NULL DEFAULT NULL ;