
DROP TABLE IF EXISTS `vehicle_Sub_Type`;

CREATE TABLE `vehicle_Sub_Type` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `lastUpdate` DATETIME NOT NULL,
  `itemCode` VARCHAR(255) NOT NULL,
  `itemValue` VARCHAR(255) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `id_UNIQUE` (`id` ASC),
  INDEX `fk_vehicle_Sub_Type_1_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_vehicle_Sub_Type_1`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

      
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`whetherChild`,`whetherParent`,
`droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1,NULL,'vehicle_Sub_Type','VEHICLE_SUB_TYPE','\0','\0',NULL,1,@currentTimeStamp);

SELECT * FROM standard_master_items;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId + 1, 'code', 'ITEM_CODE', @standardMasterMaxId + 1, 'varchar', '1', 0, 0, 0, 1, '1', SYSDATE());

SELECT * FROM standard_master_items;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId + 1, 'value', 'ITEM_VALUE', @standardMasterMaxId + 1, 'varchar', '2', 0, 0, 0, 1, '1', SYSDATE());
 
 
ALTER TABLE `resources` 
ADD COLUMN `vehicleSubTypeId` BIGINT(20) NULL DEFAULT NULL AFTER `nameToBePrinted`,
ADD INDEX `fk_resources_1_idx` (`vehicleSubTypeId` ASC);
ALTER TABLE `resources` 
ADD CONSTRAINT `fk_resources_1`
  FOREIGN KEY (`vehicleSubTypeId`)
  REFERENCES `vehicle_Sub_Type` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
 
  
  ALTER TABLE `vehicle_emission_detail` 
DROP FOREIGN KEY `RefVehicleId231`;
ALTER TABLE `vehicle_emission_detail` 
CHANGE COLUMN `vechicleId` `vehicleId` BIGINT(20) NOT NULL ;
ALTER TABLE `vehicle_emission_detail` 
ADD CONSTRAINT `RefVehicleId231`
  FOREIGN KEY (`vehicleId`)
  REFERENCES `vehicle` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

ALTER TABLE `vehicle_insurance_detail` 
DROP FOREIGN KEY `Refvechicle1001`;
ALTER TABLE `vehicle_insurance_detail` 
CHANGE COLUMN `vechicleId` `vehicleId` BIGINT(20) NOT NULL ;
ALTER TABLE `vehicle_insurance_detail` 
ADD CONSTRAINT `Refvechicle1001`
  FOREIGN KEY (`vehicleId`)
  REFERENCES `vehicle` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;


ALTER TABLE `vehicle_road_tax_detail` 
DROP FOREIGN KEY `Refvehicleid1102`;
ALTER TABLE `vehicle_road_tax_detail` 
CHANGE COLUMN `vechicleId` `vehicleId` BIGINT(20) NOT NULL ;
ALTER TABLE `vehicle_road_tax_detail` 
ADD CONSTRAINT `Refvehicleid1102`
  FOREIGN KEY (`vehicleId`)
  REFERENCES `vehicle` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

