CREATE TABLE `domicile` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `itemValue` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_domicile_1_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_domicile_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'domicile','DOMICILE','Fees & Payments','COMMON_MASTER',0,0,NULL,1,SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 1, 1, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'value', 'ITEM_VALUE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 1, 1, '1', SYSDATE());


INSERT INTO `domicile`
(
`itemCode`,
`itemValue`,
`lastUpdate`,
`lastUpdatedBy`)
VALUES
(
'state',
'MP',
sysdate(),
1);

INSERT INTO `domicile`
(
`itemCode`,
`itemValue`,
`lastUpdate`,
`lastUpdatedBy`)
VALUES
(
'other state',
'Outside MP',
sysdate(),
1);




ALTER TABLE `applicant_person` 
ADD COLUMN `domicileId` BIGINT(20) NULL AFTER `religionId`,
ADD INDEX `fk_applicant_person_ibfk_9_idx` (`domicileId` ASC);
ALTER TABLE `applicant_person` 
ADD CONSTRAINT `fk_applicant_person_ibfk_9`
  FOREIGN KEY (`domicileId`)
  REFERENCES `domicile` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `persons` 
ADD COLUMN `domicileId` BIGINT(20) NULL AFTER `physicalCharacteristicId`,
ADD INDEX `persons_ibfk_5_idx` (`domicileId` ASC);
ALTER TABLE `persons` 
ADD CONSTRAINT `persons_ibfk_5`
  FOREIGN KEY (`domicileId`)
  REFERENCES `domicile` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;



INSERT INTO `drool_rules`
(
`droolCode`,
`droolPrintName`,
`droolFor`,
`description`,
`lastUpdatedBy`,
`lastUpdate`)
VALUES
(
'DOMICILE_STATE',
'Domicile State',
'FEE',
'Fee is applicable based on domicile on admission stage',
1,
sysdate());

INSERT INTO `drool_rules`
(
`droolCode`,
`droolPrintName`,
`droolFor`,
`description`,
`lastUpdatedBy`,
`lastUpdate`)
VALUES
(
'DOMICILE_OUTSIDE_STATE',
'Domicile Outside State',
'FEE',
'Fee is applicable based on domicile on admission stage',
1,
sysdate());


ALTER TABLE `fee_plan_rules` 
ADD COLUMN `droolId` BIGINT(20) NULL AFTER `inheritFromRule`,
ADD INDEX `fk_fee_plan_rules_1_idx` (`droolId` ASC);
ALTER TABLE `fee_plan_rules` 
ADD CONSTRAINT `fk_fee_plan_rules_1`
  FOREIGN KEY (`droolId`)
  REFERENCES `drool_rules` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ALTER TABLE `users` 
CHANGE COLUMN `lockedOn` `lockedOn` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP ;

