-- mobile integration event table
CREATE TABLE IF NOT EXISTS `mobile_event` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `eventId` bigint(20) NOT NULL,
  `mobileEventId` varchar(255) DEFAULT NULL,
  `instituteId` varchar(255) DEFAULT NULL,
  `apiAction` varchar(20) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `errorMessage` TEXT DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_mobile_event_updatedby` (`lastUpdatedBy`),
  CONSTRAINT `fk_mobile_event_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `mobile_time_table` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `groupId` bigint(20) NOT NULL,
  `mobileTimeTableId` varchar(255) DEFAULT NULL,
  `instituteId` varchar(255) DEFAULT NULL,
  `apiAction` varchar(20) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `errorMessage` TEXT DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_mobile_time_table_groupId` (`groupId`),
  KEY `fk_mobile_time_table_updatedby` (`lastUpdatedBy`),
  CONSTRAINT `fk_mobile_time_table_groupId` FOREIGN KEY (`groupId`) REFERENCES `mobile_group` (`id`),
  CONSTRAINT `fk_mobile_time_table_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `mobile_payment_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `instituteId` varchar(255) DEFAULT NULL,
  `paytmMerchantId` varchar(255) DEFAULT NULL,
  `paytmMerchantKey` varchar(255) DEFAULT NULL,
  `paytmMerchantWebsite` varchar(255) DEFAULT NULL,
  `apiAction` varchar(20) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `errorMessage` TEXT DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_mobile_payment_info_updatedby` (`lastUpdatedBy`),
  CONSTRAINT `fk_mobile_payment_info_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
