CREATE TABLE `student_discount_master` (
  `id` bigint(20) NOT NULL,
  `discountMasterId` bigint(20) NOT NULL,
  `studentId` bigint(20) NOT NULL,
  `applicableFrom` date NOT NULL,
  `validTill` date NOT NULL,
  `appliedDate` date NOT NULL,
  `approvalRejectionDate` date DEFAULT NULL,
  `appliedBy` bigint(20) NOT NULL,
  `studentDiscountStatus` varchar(255) NOT NULL DEFAULT 'APPLIED',
  `discountAmount` double(20,2) DEFAULT NULL,
  `discountPercentage` double(20,2) DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `approvedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_student_discount_master_students1234_idx` (`studentId`),
  KEY `fk_student_discount_master_discount_master1234_idx` (`discountMasterId`),
  KEY `fk_student_discount_master_appliedBy1234_idx` (`appliedBy`),
  KEY `fk_student_discount_master_lastUpdatedBy1234_idx` (`lastUpdatedBy`),
  KEY `fk_student_discount_master_approved_by1234_idx` (`approvedBy`),
  CONSTRAINT `fk_student_discount_master_appliedBy1234` FOREIGN KEY (`appliedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_student_discount_master_approved_by1234` FOREIGN KEY (`approvedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_student_discount_master_discount_master1234` FOREIGN KEY (`discountMasterId`) REFERENCES `discount_master` (`id`),
  CONSTRAINT `fk_student_discount_master_lastUpdatedBy1234` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_student_discount_master_students1234` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1