CREATE TABLE `evaluation_group_marksheet` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evaluationGroupId` bigint(20) NOT NULL,
  `batchId` bigint(20) NOT NULL,
  `templateId` bigint(20) DEFAULT NULL,
  `publishDate` date DEFAULT NULL,
  `marksheetFilePattern` varchar(60) DEFAULT NULL,
  `isConsiderProgramTransfer` bit(1) NOT NULL DEFAULT b'1',
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `primary_key_eval_group_and_batch_id` (`evaluationGroupId`,`batchId`),
  KEY `fk_evaluation_group_marksheet_1_idx` (`evaluationGroupId`),
  KEY `fk_evaluation_group_marksheet_2_idx` (`batchId`),
  KEY `fk_evaluation_group_marksheet_3_idx` (`templateId`),
  KEY `fk_evaluation_group_marksheet_4_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_evaluation_group_marksheet_1` FOREIGN KEY (`evaluationGroupId`) REFERENCES `evaluation_group` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_evaluation_group_marksheet_2` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_evaluation_group_marksheet_3` FOREIGN KEY (`templateId`) REFERENCES `report_template_configuration` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_evaluation_group_marksheet_4` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `evaluation_group_marksheet_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `evaluationGroupMarksheetId` bigint(20) DEFAULT NULL,
  `admissionId` bigint(20) NOT NULL,
  `marksheetPath` varchar(255) DEFAULT NULL,
  `isMarksheetPrint` bit(1) NOT NULL DEFAULT b'0',
  `lastUpdatedBy` bigint(20) NOT NULL,
  `isPublishMarksheet` bit(1) NOT NULL DEFAULT b'0',
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `primary_key_group_marksheet_and_admission_id` (`evaluationGroupMarksheetId`,`admissionId`),
  KEY `fk_evaluation_group_marksheet_details_1_idx` (`admissionId`),
  KEY `fk_evaluation_group_marksheet_details_2_idx` (`evaluationGroupMarksheetId`),
  CONSTRAINT `fk_evaluation_group_marksheet_details_1` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_evaluation_group_marksheet_details_2` FOREIGN KEY (`evaluationGroupMarksheetId`) REFERENCES `evaluation_group_marksheet` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=latin1;