CREATE TABLE `emp_approval_level` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `empId` bigint(20) NOT NULL,
  `approverType` varchar(15) DEFAULT NULL COMMENT 'Possible values are Sequential, Parallel and Auto',
  `levelId` bigint(1) DEFAULT NULL COMMENT 'Possible values are 1, 2, 3 and 4',
  `approverId` bigint(20) DEFAULT NULL,
  `slaDays` bigint(3) DEFAULT NULL,
  `remark` varchar(225) DEFAULT NULL COMMENT 'Comment/Remark provided by hr',
  `fromDate` date DEFAULT NULL COMMENT 'Date from which the approver is assigned to the employee',
  `toDate` date DEFAULT NULL COMMENT 'Date to which the approver is assigned to the employee',
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `empId` (`empId`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  KEY `emp_approval_level_ibfk_2_idx` (`approverId`),
  CONSTRAINT `emp_approval_level_ibfk_1` FOREIGN KEY (`approverId`) REFERENCES `staffs` (`userId`),
  CONSTRAINT `emp_approval_level_ibfk_2` FOREIGN KEY (`approverId`) REFERENCES `staffs` (`userId`),
  CONSTRAINT `emp_approval_level_ibfk_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8;
