DROP TRIGGER IF EXISTS effective_marks_update_trigger;
DELIMITER //
CREATE TRIGGER effective_marks_update_trigger 
 AFTER UPDATE ON exam_event_detail 
 FOR EACH ROW 
BEGIN
	set sql_safe_updates=0;
UPDATE examination_result result
        INNER JOIN
    exam_event_detail dy ON dy.eventId = result.evaluationDetailSequenceId
        INNER JOIN
    evaluation_type_course typeCourse ON dy.evaluationTypeCourseId = typeCourse.id
        AND typeCourse.courseVariantId = result.courseVariantId
        AND typeCourse.periodId = result.periodId
        AND typeCourse.sectionId = result.sectionId 
SET 
    result.calculationDone = FALSE,
    result.courseRank = NULL,
    result.effectiveMarks = ROUND((finalMarks * dy.weightage / 100), 2),
    result.lastUpdate = CASE
        WHEN NEW.lastUpdate IS NOT NULL THEN NEW.lastUpdate
        ELSE NOW()
    END
WHERE
    finalMarks IS NOT NULL
        AND ROUND(result.effectiveMarks, 2) <> ROUND((finalMarks * dy.weightage / 100), 2)
        AND dy.id = NEW.id;
	set sql_safe_updates=1;
END;//
DELIMITER ;