set sql_safe_updates=0;

set @standardMasterId=(select id from standard_master where masterName='ACADEMIC_TOPICS');

UPDATE `standard_master_items`
SET diaplayOrder=2
WHERE `standardMasterId`=@standardMasterId AND dbFieldName ='itemCode';

UPDATE `standard_master_items`
SET diaplayOrder=3
WHERE `standardMasterId`=@standardMasterId AND dbFieldName ='itemValue';

ALTER TABLE `academic_topics` 
ADD COLUMN `categoryTopic` VARCHAR(255) NULL AFTER `itemValue`;

set sql_safe_updates=1;

-- Update Add academic topic category 
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`,`emunType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES (@ItemsMaxId + 1, 'categoryTopic', 'CATEGORY', @standardMasterId, 'Enum','ACADEMIC_TOPIC_CATEGORY','1', 0, 0, 0, 0, '1', SYSDATE());

 