CREATE TABLE `application_program_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `applicationProgramId` bigint(20) NOT NULL,
  `offerLetterSentDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `sentBy` bigint(20) NOT NULL,
  `offerLetterAcceptanceDate` timestamp NULL,
  `offerLetterAcceptedByUserId`  bigint(20) DEFAULT NULL,
  `offerLetterAcceptedByExternalUserId`  bigint(20) DEFAULT NULL,
  `path` VARCHAR(255) NULL DEFAULT NULL,
  `fileName` VARCHAR(255) NULL DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_apdetails_apid` FOREIGN KEY (`applicationProgramId`) REFERENCES `application_program` (`id`),
  CONSTRAINT `fk_apdetails_sentBy` FOREIGN KEY (`sentBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_apdetails_accptedByUser` FOREIGN KEY (`offerLetterAcceptedByUserId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_apdetails_accptedByExtUser` FOREIGN KEY (`offerLetterAcceptedByExternalUserId`) REFERENCES `external_users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
);