CREATE TABLE `remark_user_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `isDeletable` bit(1) NOT NULL DEFAULT b'1',
  `isEditable` bit(1) NOT NULL DEFAULT b'0',
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `itemCode_UNIQUE` (`itemCode`),
  UNIQUE KEY `itemValue_UNIQUE` (`itemValue`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `fk_remark_user_type_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'remark_user_type','REMARK_USER_TYPE','Examinations','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);

INSERT INTO `standard_master_items` ( `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) VALUES ( 'itemCode', 'ITEM_CODE', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1', SYSDATE());
INSERT INTO `standard_master_items` ( `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) VALUES ( 'itemValue', 'ITEM_VALUE', @standardMasterMaxId+1, 'Varchar', '2', 0, 0, 0, 0, '1', SYSDATE());

INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('masterNames','REMARK_USER_TYPE','Remark User Type','Remark User Type',now(),1);


INSERT INTO `remark_user_type` (`id`, `itemCode`, `itemValue`, `isDeletable`, `isEditable`, `lastUpdatedBy`, `lastUpdate`) VALUES ('1','CLASS_TEACHER','Class Teacher',0,0,'1','2019-06-19 11:25:22');

INSERT INTO `remark_user_type` (`id`, `itemCode`, `itemValue`, `isDeletable`, `isEditable`, `lastUpdatedBy`, `lastUpdate`) VALUES ('2','PRINCIPAL','Principal',0,0,'1','2019-06-19 11:25:22');

INSERT INTO `remark_user_type` (`id`, `itemCode`, `itemValue`, `isDeletable`, `isEditable`, `lastUpdatedBy`, `lastUpdate`) VALUES ('3','DEPUTY_PRINCIPAL','Deputy Principal',0,0,'1','2019-06-19 11:25:22');

INSERT INTO `remark_user_type` (`id`, `itemCode`, `itemValue`, `isDeletable`, `isEditable`, `lastUpdatedBy`, `lastUpdate`) VALUES ('4','GRADE_CONTROLLER','Grade Controller',0,0,'1','2019-06-19 11:25:22');

INSERT INTO `remark_user_type` (`id`, `itemCode`, `itemValue`, `isDeletable`, `isEditable`, `lastUpdatedBy`, `lastUpdate`) VALUES ('5','MENTOR','Mentor',0,0,'1','2019-06-19 11:25:22');

INSERT INTO `remark_user_type` (`id`, `itemCode`, `itemValue`, `isDeletable`, `isEditable`, `lastUpdatedBy`, `lastUpdate`) VALUES ('6','GRADE_HEAD','Grade Head',0,0,'1','2019-06-19 11:25:22');

