CREATE TABLE `parent_payment_term_settings` (
  `id` BIGINT(20) NOT NULL,
  `studentId` BIGINT(20) NULL,
  `feePlanId` BIGINT(20) NULL,
  `feeRuleId` BIGINT(20) NULL,
  `whetherStudentContinueInNAY` BIT NULL,
  `nextPBSId` BIGINT(20) NULL,
  `approvalStatus` VARCHAR(50) NULL,
  `lastUpdate` DATE NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `RefUsers201907311150_idx` (`lastUpdatedBy` ASC),
  INDEX `RefFeePlan201907311151_idx` (`feePlanId` ASC),
  INDEX `RefStudent201907311152_idx` (`studentId` ASC),
  INDEX `RefProgramBatchSeat201907311206_idx` (`nextPBSId` ASC),
  INDEX `RefFeeRule201907311211_idx` (`feeRuleId` ASC),
  CONSTRAINT `RefUsers201907311150`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE CASCADE
    ON UPDATE NO ACTION,
  CONSTRAINT `RefFeePlan201907311151`
    FOREIGN KEY (`feePlanId`)
    REFERENCES `fee_plan` (`id`)
    ON DELETE CASCADE
    ON UPDATE NO ACTION,
  CONSTRAINT `RefStudent201907311152`
    FOREIGN KEY (`studentId`)
    REFERENCES `students` (`userId`)
    ON DELETE CASCADE
    ON UPDATE NO ACTION,
  CONSTRAINT `RefProgramBatchSeat201907311206`
    FOREIGN KEY (`nextPBSId`)
    REFERENCES `prog_batch_seat_config` (`id`)
    ON DELETE CASCADE
    ON UPDATE NO ACTION,
  CONSTRAINT `RefFeeRule201907311211`
    FOREIGN KEY (`feeRuleId`)
    REFERENCES `fee_plan_rule_stage` (`id`)
    ON DELETE CASCADE
    ON UPDATE NO ACTION);
