CREATE TABLE `campaign_new` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `campaignType` varchar(55) DEFAULT NULL,
  `presentationType` varchar(45) DEFAULT NULL,
  `presentationSubType` varchar(45) DEFAULT NULL,
  `presentationSubTypeName` varchar(60) DEFAULT NULL,
  `intakeYearId` bigint(20) DEFAULT NULL,
  `modeofDelivery` varchar(15) DEFAULT NULL,
  `registrationType` varchar(15) DEFAULT NULL,
  `ownerId` bigint(20) DEFAULT NULL,
  `venue` varchar(100) DEFAULT NULL,
  `schoolPriority` varchar(500) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `numberOfCampaign` varchar(50) DEFAULT NULL,
  `campaignName` varchar(500) DEFAULT NULL,
  `numberOfleadsTargeted` int(5) DEFAULT NULL,
  `createdOn` date DEFAULT NULL,
  `status` varchar(15) DEFAULT NULL,
  `contactPersonName` varchar(55) DEFAULT NULL,
  `emailAddress` varchar(100) DEFAULT NULL,
  `mobileNumber` varchar(15) DEFAULT NULL,
  `mobileCountryCode` varchar(10) DEFAULT NULL,
  `advertisementURL` varchar(255) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `remarks` varchar(1000) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_campaign_new_intake_yr_idx` (`intakeYearId`),
  KEY `fk_campaign_new_owner_idx` (`ownerId`),
  KEY `fk_campaign_new_document_idx` (`documentId`),
  KEY `fk_campaign_new_user_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_campaign_new_document` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_campaign_new_intake_yr` FOREIGN KEY (`intakeYearId`) REFERENCES `intake_year` (`id`),
  CONSTRAINT `fk_campaign_new_owner` FOREIGN KEY (`ownerId`) REFERENCES `staffs` (`userId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_campaign_new_user` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;
