set sql_safe_updates=0;
update 
    marksheet AS m
        INNER JOIN
    (SELECT DISTINCT m.id as markseetId,
        esr.admissionId,
            esr.courseVariantId,
            esr.sectionId,
            esr.periodId,
            esr.evalSequenceId,
            esr.evalPlanLevelTwoId,
            esr.evalPlanLevelOneId,
            esr.evaluationPlanId,
            esr.genericRemark
    FROM
        evaluation_student_remark AS esr
    INNER JOIN marksheet AS m ON esr.admissionId = m.admissionId
        AND esr.courseVariantId = m.courseVariantId
        AND esr.sectionId = m.sectionId
        AND esr.periodId = m.periodId
        AND esr.evaluationPlanId = m.evaluationPlanId
        AND (m.evaluationPlanLevelTwoId IS NULL
        AND m.evaluationPlanLevelOneId IS NOT NULL
        AND esr.evalPlanLevelOneId = m.evaluationPlanLevelOneId)
        AND length(esr.genericRemark)>0 UNION SELECT DISTINCT m.id as markseetId,
        esr.admissionId,
            esr.courseVariantId,
            esr.sectionId,
            esr.periodId,
            esr.evalSequenceId,
            esr.evalPlanLevelTwoId,
            esr.evalPlanLevelOneId,
            esr.evaluationPlanId,
            esr.genericRemark
    FROM
        evaluation_student_remark AS esr
    INNER JOIN marksheet AS m ON esr.admissionId = m.admissionId
        AND esr.courseVariantId = m.courseVariantId
        AND esr.sectionId = m.sectionId
        AND esr.periodId = m.periodId
        AND esr.evaluationPlanId = m.evaluationPlanId
        AND (m.evaluationPlanThreeId IS NULL
        AND m.evaluationPlanLevelTwoId IS NOT NULL
        AND esr.evalPlanLevelTwoId = m.evaluationPlanLevelTwoId)
        AND length(esr.genericRemark)>0  UNION SELECT DISTINCT m.id as markseetId,
        esr.admissionId,
            esr.courseVariantId,
            esr.sectionId,
            esr.periodId,
            esr.evalSequenceId,
            esr.evalPlanLevelTwoId,
            esr.evalPlanLevelOneId,
            esr.evaluationPlanId,
            esr.genericRemark
    FROM
        evaluation_student_remark AS esr
    INNER JOIN marksheet AS m ON esr.admissionId = m.admissionId
        AND esr.courseVariantId = m.courseVariantId
        AND esr.sectionId = m.sectionId
        AND esr.periodId = m.periodId
        AND esr.evaluationPlanId = m.evaluationPlanId
        AND (m.evaluationPlanLevelFourId IS NULL
        AND m.evaluationPlanThreeId IS NOT NULL
        AND esr.evalSequenceId = m.evaluationPlanThreeId)
        AND length(esr.genericRemark)>0 ) AS gr ON 
        m.id=gr.markseetId
        AND m.admissionId = gr.admissionId
        AND m.sectionId = gr.sectionId
        AND m.periodId = gr.periodId
        AND m.courseVariantId = gr.courseVariantId
        AND m.evaluationPlanId = gr.evaluationPlanId
        AND ((m.evaluationPlanLevelOneId = gr.evalPlanLevelOneId
        AND m.evaluationPlanLevelTwoId IS NULL)
        OR (m.evaluationPlanLevelTwoId = gr.evalPlanLevelTwoId
        AND m.evaluationPlanThreeId IS NULL)
        OR (m.evaluationPlanThreeId = gr.evalSequenceId))
set m.genericRemark=gr.genericRemark;
set sql_safe_updates=1; 