CREATE TABLE `hr_leave_credit_setting` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `code` varchar(70) NOT NULL,
  `hrLeaveTypeId` BIGINT(20) NOT NULL,
  `periodStartDate` DATE NOT NULL,
  `periodEndDate` DATE NOT NULL,
  `year` INT NOT NULL,
  `monthStartsFrom` VARCHAR(50) NOT NULL,
  `hrLeaveCreditType` VARCHAR(45) NOT NULL,
  `leaveCreditPeriod` VARCHAR(45) DEFAULT NULL,
  `isProratedCredit` BIT NOT NULL DEFAULT b'0',
  `creditBalance` DOUBLE NOT NULL,
  `maxCreditBalance` DOUBLE NOT NULL,
  `isLeaveLapse` BIT NOT NULL DEFAULT b'0',
  `leaveLapsePeriod` VARCHAR(45) NULL,
  `isLeaveCarryForward` BIT NOT NULL DEFAULT b'0',
  `leaveCarryForwardPeriod` VARCHAR(45) NULL,
  `maxDaysToCarryForward` DOUBLE NULL,
  `isLeaveEncashment` BIT NOT NULL DEFAULT b'0',
  `leaveEncashmentPeriod` VARCHAR(45) NULL,
  `minBalanceForLeaveEncashment` DOUBLE NULL,
  `maxDaysForLeaveEncashment` DOUBLE NULL,
  `elgibilityBasedOn` VARCHAR(45) NULL,
  `hrEmployeeAttributeType` VARCHAR(45) NULL,
  `gender` VARCHAR(100) NULL,
  `departmentIds`  VARCHAR(255) NULL,
  `userGroupType` VARCHAR(255) NULL,
  `isClosed` BIT NOT NULL DEFAULT b'0',
  `lastUpdatedBy` BIGINT(20) NOT NULL DEFAULT '1',
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_hr_leave_credit_setting_hr_leave_type_id_idx` (`hrLeaveTypeId` ASC),
  CONSTRAINT `fk_hr_leave_credit_setting_hr_leave_type_id`
    FOREIGN KEY (`hrLeaveTypeId`)
    REFERENCES `hr_leave_type` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
    