CREATE TABLE `application_default_user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `defaultUserId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_application_default_user_academyLocationId_idx` (`academyLocationId` ASC),
  INDEX `fk_application_default_user_defaultuserid_idx` (`defaultUserId` ASC),
  INDEX `fk_application_default_user_lastUpdatedByid_idx` (`lastUpdatedBy` ASC),
  UNIQUE INDEX `academyLocationId_UNIQUE` (`academyLocationId` ASC),
  UNIQUE INDEX `defaultUserId_UNIQUE` (`defaultUserId` ASC),
  CONSTRAINT `fk_application_default_user_academyLocationId` FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_application_default_user_defaultuserid` FOREIGN KEY (`defaultUserId`)
    REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_application_default_user_lastUpdatedByid` FOREIGN KEY (`lastUpdatedBy`) 
  REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT);