set sql_safe_updates=0;
CREATE OR REPLACE VIEW `subject_wise_report_view` AS SELECT DISTINCT
    al.displayName AS 'Brand',
    al.locationName AS 'Campus',
    al.id AS 'Academy_Location_Id',
    pg.groupName AS 'School Phase',
    prgm.programNameToBePrint AS 'Grade',
    pc.categoryName AS 'Grade Category',
    batch.printName AS 'Intake',
    period.printName AS 'Period',
    person.printName AS 'Student Name',
    usr.code AS 'Student Id',
    course.nameToBePrinted AS 'Subject',
    cv.courseVariantCode AS 'Subject Variant',
    planRank.marksOrGrade AS 'Marking Type',
    planRank.marksObtainedFrom AS 'Max Marks',
    planRank.minMarksOrGrade AS 'Min Marks',
    course.courseCredits AS 'Subject Credits',
    fac.printName AS 'Teacher',
    cc.categoryName AS 'Subject Category',
    planRank.effectiveMarks AS 'Subject Level Marks',
    planRank.grade AS 'Subject Grade',
    avrg.marks AS 'Grade Average',
    planRank.effectiveMarks AS 'Percentage',
    planRank.courseRank AS 'Subject Rank',
    planRank.status AS 'Result Status'
FROM
    evaluation_plan_rank AS planRank
        INNER JOIN
    admission AS admission ON admission.id = planRank.admissionId
        INNER JOIN
    academy_location AS al ON admission.academyLocationId = al.id
        INNER JOIN
    students AS stu ON admission.studentId = stu.userId
        INNER JOIN
    users AS usr ON stu.userId = usr.id
        INNER JOIN
    persons AS person ON stu.personId = person.id
        LEFT OUTER JOIN
    course_variants AS cv ON cv.id = planRank.courseVariantId
        LEFT OUTER JOIN
    courses AS course ON course.id = cv.courseId
        INNER JOIN
    prog_batch_period_config AS period ON period.id = planRank.periodId
        INNER JOIN
    batches AS batch ON batch.id = period.programBatchId
        INNER JOIN
    programs AS prgm ON prgm.id = batch.programId
        LEFT OUTER JOIN
    program_group AS pg ON pg.id = prgm.programGroupId
        LEFT OUTER JOIN
    program_category AS pc ON pc.id = prgm.programCategoryId
        LEFT JOIN
    course_category AS cc ON cc.id = course.courseCategoryId
        INNER JOIN
    sections AS section ON section.id = planRank.sectionId
        LEFT OUTER JOIN
    program_batch_course_param AS param ON param.courseVarientId = cv.id
        LEFT OUTER JOIN
    prog_batch_course_faculty AS pbcf ON pbcf.progBatchCourseParamId = param.id
        LEFT OUTER JOIN
    users AS fac ON fac.id = pbcf.facultyId
        LEFT OUTER JOIN
    exam_course_grade_average AS avrg ON avrg.courseId = course.id
		AND planRank.evaluationPlanId = avrg.planId AND avrg.periodId=planRank.periodId; 
set sql_safe_updates=1;

