set sql_safe_updates=0;
CREATE OR REPLACE VIEW `detention_report_view` AS SELECT DISTINCT
    al.displayName AS 'Brand',
    al.locationName AS 'Campus',
    al.id AS 'Academy_Location_id',
    pg.groupName AS 'School Phase',
    prgm.programNameToBePrint AS 'Grade',
    pc.categoryName AS 'Grade Category',
    batch.printName AS 'Intake',
    period.printName AS 'Period',
    course.nameToBePrinted AS 'Subject',
    cv.courseVariantCode AS 'Subject Variant',
    fac.printName AS 'Teacher',
    cc.categoryName AS 'Subject Category',
    type.printNameInMarksheet AS 'Type',
    subType.printNameInMarksheet AS 'Sub Type',
    method.printNameInMarksheet AS 'Method',
    CASE
        WHEN evntDetail.eventName IS NULL THEN evnt.detailSequenceNumber
        WHEN evntDetail.eventName IS NOT NULL THEN evntDetail.eventName
        ELSE NULL
    END AS 'Event',
    usr.printName AS 'Student Name',
    resultEvnt.detentionResion AS 'Reason'
FROM
    exam_result_event_students AS resultEvnt
        INNER JOIN
    admission AS admission ON resultEvnt.admissionId = admission.id
        INNER JOIN
    students AS stu ON stu.userId = admission.studentId
        INNER JOIN
    users AS usr ON usr.id = stu.userId
        INNER JOIN
    academy_location AS al ON al.id = admission.academyLocationId
        INNER JOIN
    prog_batch_period_config AS period ON resultEvnt.periodId = period.id
        INNER JOIN
    batches AS batch ON batch.id = period.programBatchId
        INNER JOIN
    programs AS prgm ON prgm.id = batch.programId
        LEFT OUTER JOIN
    program_group AS pg ON pg.id = prgm.programGroupId
        LEFT OUTER JOIN
    program_category AS pc ON pc.id = prgm.programCategoryId
        LEFT OUTER JOIN
    course_variants AS cv ON resultEvnt.courseVariantId = cv.id
        LEFT OUTER JOIN
    courses AS course ON course.id = cv.courseId
        LEFT OUTER JOIN
    course_category AS cc ON cc.id = course.courseCategoryId
        INNER JOIN
    eval_seq_detail AS evnt ON evnt.id = resultEvnt.eventId
        INNER JOIN
    evaluation_sequence AS method ON method.id = evnt.evalSequenceId
        INNER JOIN
    sequence_header AS header ON header.id = method.evalSequenceId
        INNER JOIN
    evaluation_plan_level_two AS subType ON subType.id = method.evalPlanLevelTwoId
        INNER JOIN
    evaluation_plan_level_one AS type ON type.id = subType.evalPlanLevelOneId
        INNER JOIN
    program_batch_course_param AS param ON resultEvnt.courseVariantId =param.courseVarientId
        AND resultEvnt.periodId = param.progBatchPeriodConfigId
        INNER JOIN
    prog_batch_course_faculty AS pbcf ON param.id = pbcf.progBatchCourseParamId 
        INNER JOIN
    users AS fac ON fac.id = pbcf.facultyId
        LEFT OUTER JOIN
    evaluation_type_course typeCourse ON resultEvnt.courseVariantId = typeCourse.courseVariantId
        AND resultEvnt.periodId = typeCourse.periodId
        LEFT OUTER JOIN
    exam_event_detail evntDetail ON resultEvnt.eventId = evntDetail.eventId
        AND evntDetail.evaluationTypeCourseId = typeCourse.id
WHERE
    resultEvnt.whetherDetention = TRUE group by resultEvnt.id
ORDER BY al.locationName ASC , al.locationName ASC , pg.groupName ASC , prgm.programNameToBePrint ASC ,
 pc.categoryName ASC , batch.printName ASC , period.printName ASC , usr.printName ASC;   
set sql_safe_updates=1;

