DELIMITER $$

DROP PROCEDURE IF EXISTS RS_FUTURE_DATE_DAYS $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE RS_FUTURE_DATE_DAYS()

BEGIN
  
   -- Insert new record in email table, if it doesn't already exist
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' AND keyName='RS_FUTURE_DATE_DAYS' )) THEN
    
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `lastUpdate`, `lastUpdatedBy`)
	VALUES ('TRANSLATIONS', 'RS_FUTURE_DATE_DAYS', 'Future Date Allowed (In Days)', 'Future Date Allowed (In Days)', now(), '1');
  END IF;

END $$

-- Execute the stored procedure
CALL RS_FUTURE_DATE_DAYS() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS RS_FUTURE_DATE_DAYS $$
 
DELIMITER ;