DELIMITER $$

DROP PROCEDURE IF EXISTS V202001091510__CreateReceiptCurrencyTable $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001091510__CreateReceiptCurrencyTable()

BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='receipt_currency' )) THEN
  
CREATE TABLE `receipt_currency` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `receiptCurrencyCode` varchar(10) NOT NULL,
  `receiptCurrencyName` varchar(100) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `invoiceCurrencyId` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_receipt_currency_to_invoice_currency_idx` (`invoiceCurrencyId`),
  CONSTRAINT `fk_receipt_currency_to_invoice_currency` FOREIGN KEY (`invoiceCurrencyId`) REFERENCES `invoice_currency` (`id`),
  CONSTRAINT `fk_receipt_currency_to_user` FOREIGN KEY (`invoiceCurrencyId`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
	
  END IF;

END $$

-- Execute the stored procedure
CALL V202001091510__CreateReceiptCurrencyTable() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001091510__CreateReceiptCurrencyTable $$
 
DELIMITER ;