DELIMITER $$

DROP PROCEDURE IF EXISTS UITranslationLeaveCreditSettingViewMsg $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE UITranslationLeaveCreditSettingViewMsg()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'VIEW_LEAVE_CREDIT_SETTINGS' )) THEN
    
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
    VALUES ('TRANSLATIONS','VIEW_LEAVE_CREDIT_SETTINGS','View Leave Credit Setting','View Leave Credit Setting',now(),1);
   
  END IF;
  
END $$


-- Execute the stored procedure
CALL UITranslationLeaveCreditSettingViewMsg() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS UITranslationLeaveCreditSettingViewMsg $$
 
DELIMITER ;