DELIMITER $$

DROP PROCEDURE IF EXISTS librarycardnumbermapping $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE librarycardnumbermapping()

BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='library_card_number_mapping')) THEN
    
CREATE TABLE `library_card_number_mapping` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `userTypeId` bigint(20) NOT NULL,
  `libraryCardNumberType` varchar(255) NOT NULL DEFAULT 'null',
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_library_card_number_mapping_1_idx` (`userTypeId`),
  KEY `fk_library_card_number_mapping_2_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_library_card_number_mapping_1` FOREIGN KEY (`userTypeId`) REFERENCES `user_groups` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_library_card_number_mapping_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
	
  END IF;

END $$

-- Execute the stored procedure
CALL librarycardnumbermapping $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS librarycardnumbermapping $$
 
DELIMITER ;