DELIMITER $$

DROP PROCEDURE IF EXISTS V202001291016__AlterHostelRestrictionType_addGenderIdColumn $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001291016__AlterHostelRestrictionType_addGenderIdColumn()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='hostel_restriction_type' 
  AND column_name='genderId')) THEN
  
    -- ALTER TABLE QUERY;
    set foreign_key_checks=0;
    ALTER TABLE `hostel_restriction_type` 
    ADD COLUMN `genderId` BIGINT(20) NULL DEFAULT NULL AFTER `restrictionType`,
    ADD INDEX `fk_hostel_restriction_type_genderId_idx` (`genderId` ASC);
    ALTER TABLE `hostel_restriction_type` 
    ADD CONSTRAINT `fk_hostel_restriction_type_genderId`
     FOREIGN KEY (`genderId`)
    REFERENCES `gender` (`id`)
   ON DELETE NO ACTION
   ON UPDATE NO ACTION;
   set foreign_key_checks=1;
  
  END IF;

END $$

-- Execute the stored procedure
CALL V202001291016__AlterHostelRestrictionType_addGenderIdColumn $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001291016__AlterHostelRestrictionType_addGenderIdColumn $$
 
DELIMITER ;