DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402154236__Create_fee_plan_structure $$
CREATE PROCEDURE V20200402154236__Create_fee_plan_structure()
BEGIN


IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'Fee_Plan_Structure')) THEN 
DROP view `Fee_Plan_Structure`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'fee_plan_structure')) THEN 
CREATE or REPLACE VIEW `fee_plan_structure` AS
    select 
        `al`.`academyName` AS `ACADEMY`,
        `al`.`locationName` AS `LOCATION`,
        `al`.`displayName` AS `ACADEMY_LOCATION`,
	`al`.`id` AS `Academy Location Id`,
        `pg`.`groupName` AS `PROGRAM_GROUP`,
        `pc`.`categoryName` AS `PROGRAM_CATEGORY`,
        `p`.`programSequence` AS `PROGRAM_SEQUENCE`,
        `p`.`programName` AS `PROGRAM_NAME`,
        `iy`.`itemValue` AS `INTAKE_YEAR`,
        `b`.`batchName` AS `BATCH`,
        `st`.`seatName` AS `SEAT_TYPE`,
        `fpt`.`feePlanType` AS `FEE_PLAN_TYPE`,
        `fp`.`feePlanName` AS `FEE_PLAN_NAME`,
        `fpr`.`feeRuleDesc` AS `FEE_RULE_NAME`,
        `fsm`.`stageName` AS `FEE_RULE_STAGE`,
        `fh`.`feeHeadName` AS `FEE_HEAD_NAME`,
        `fshc`.`feeAmount` AS `FEE_HEAD_AMOUNT`,
        `fpss`.`billingDate` AS `INSTALLMENT_DATE`,
        dayname(`fpss`.`billingDate`) AS `INSTALLMENT_DAY`,
        `fpss`.`amount` AS `INSTALLMENT_AMOUNT`,
        `fpss`.`dueDate` AS `INSTALLMENT_DUE_DATE`
    from
        ((((((((((((((((`fee_plan_submission_sch` `fpss`
        left join `fee_stage_head_config` `fshc` ON ((`fshc`.`id` = `fpss`.`feeStageHeadConfigId`)))
        left join `fee_heads` `fh` ON ((`fshc`.`feeHeadId` = `fh`.`id`)))
        left join `fee_plan_rule_stage` `fprs` ON ((`fprs`.`id` = `fshc`.`feePlanRuleStageId`)))
        left join `fee_stage_master` `fsm` ON ((`fsm`.`id` = `fprs`.`stageId`)))
        left join `fee_plan_rules` `fpr` ON ((`fpr`.`id` = `fprs`.`feePlanRuleId`)))
        left join `fee_plan` `fp` ON ((`fp`.`id` = `fpr`.`feePlanId`)))
        left join `fee_plan_type` `fpt` ON ((`fp`.`feePlanType` = `fpt`.`id`)))
        left join `fee_plan_acad_locations` `fpal` ON ((`fpal`.`feePlanId` = `fp`.`id`)))
        left join `academy_location` `al` ON ((`al`.`id` = `fpal`.`academyLocationId`)))
        left join `prog_batch_seat_config` `pbsc` ON ((`pbsc`.`id` = `fpal`.`progBatchSeatConfigId`)))
        left join `batches` `b` ON ((`b`.`id` = `pbsc`.`programBatchId`)))
        left join `intake_year` `iy` ON ((`iy`.`id` = `b`.`intakeYearId`)))
        left join `programs` `p` ON ((`p`.`id` = `b`.`programId`)))
        left join `program_group` `pg` ON ((`pg`.`id` = `p`.`programGroupId`)))
        left join `program_category` `pc` ON ((`pc`.`id` = `p`.`programCategoryId`)))
        left join `seat_types` `st` ON ((`st`.`id` = `pbsc`.`seatTypeId`)));
END IF; 

END $$
CALL V20200402154236__Create_fee_plan_structure () $$ 
DROP PROCEDURE IF EXISTS V20200402154236__Create_fee_plan_structure $$ 
DELIMITER ;