DELIMITER $$

DROP PROCEDURE IF EXISTS V20200417163035__Insert_UIApplicationDetail $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200417163035__Insert_UIApplicationDetail()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='TRANSPORT')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','TRANSPORT','Transport','Transport',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='DISTANCE_TO_TRAVEL')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','DISTANCE_TO_TRAVEL','Distance to Travel','Distance to Travel',now(),1);
 END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='APPLICATION_DETAILS')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','APPLICATION_DETAILS','Application Details','Application Details',now(),1);
 END IF;
 

END $$

-- Execute the stored procedure
CALL V20200417163035__Insert_UIApplicationDetail $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200417163035__Insert_UIApplicationDetail $$
 
DELIMITER ;