DELIMITER $$
DROP PROCEDURE IF EXISTS V20200427194516__Update_dataGridOfExtendTimetable $$
CREATE PROCEDURE V20200427194516__Update_dataGridOfExtendTimetable()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="TOPIC_DETAILS" )) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','TOPIC_DETAILS','Topic Details','Topic Details',now(),1);
END IF;

IF EXISTS ((select * from data_grid where gridName='Academia.view.coursetransaction.sectioncoursecoverageplan.ExtendedTimeTableCBSGrid' and portalId=1)) THEN 
update `data_grid` set 
`jsonObject`='[{"id":null,"columnName":"COURSE_NAME","dataIndex":"courseName","columnVisibility":"SHOW","sequence":1,"mandatory":false},
{"id":null,"columnName":"COURSE_VARIANT","dataIndex":"courseVariantName","columnVisibility":"SHOW","sequence":2,"mandatory":false},
{"id":null,"columnName":"SECTION","dataIndex":"sectionName","columnVisibility":"SHOW","sequence":3,"mandatory":false},
{"id":null,"columnName":"TOPIC_DETAILS","dataIndex":"assignedTopicCount","columnVisibility":"SHOW","sequence":4,"mandatory":false},
{"id":null,"columnName":"SESSION_NUMBER","dataIndex":"sessionNumber","columnVisibility":"SHOW","sequence":5,"mandatory":false},
{"id":null,"columnName":"SESSION_DATE","dataIndex":"sessionDate","columnVisibility":"SHOW","sequence":6,"mandatory":false},
{"id":null,"columnName":"START_TIME","dataIndex":"startTime","columnVisibility":"SHOW","sequence":7,"mandatory":false},

{"id":null,"columnName":"END_TIME","dataIndex":"endTime","columnVisibility":"SHOW","sequence":8,"mandatory":false},
{"id":null,"columnName":"FACULTY","dataIndex":"faculty","columnVisibility":"SHOW","sequence":9,"mandatory":false},
{"id":null,"columnName":"ROOM","dataIndex":"roomName","columnVisibility":"SHOW","sequence":10,"mandatory":false},

{"id":null,"columnName":"OPTIONAL_MANDATORY","dataIndex":"OptionalMandatory","columnVisibility":"HIDE","sequence":11,"mandatory":false},

{"id":null,"columnName":"WHETHER_ATTENDANCE_ENTERED","dataIndex":"whetherAttendanceToBeEntered","columnVisibility":"HIDE","sequence":12,"mandatory":false},

{"id":null,"columnName":"WHETHER_ATTENDANCE_MARKED","dataIndex":"studentCourseAttendanceId","columnVisibility":"SHOW","sequence":13,"mandatory":false},
{"id":null,"columnName":"LAST_UPDATED_BY","dataIndex":"attendanceMarkedBy","columnVisibility":"HIDE","sequence":14,"mandatory":false},

{"id":null,"columnName":"LAST_UPDATED","dataIndex":"attendanceMarkedAt","columnVisibility":"HIDE","sequence":15,"mandatory":false}]' where 

gridName='Academia.view.coursetransaction.sectioncoursecoverageplan.ExtendedTimeTableCBSGrid' and portalId=1;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20200427194516__Update_dataGridOfExtendTimetable () $$
DROP PROCEDURE IF EXISTS V20200427194516__Update_dataGridOfExtendTimetable $$
DELIMITER ;
