DELIMITER $$

DROP PROCEDURE IF EXISTS V20200715160510__ExaminationRevaluationDFR $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200715160510__ExaminationRevaluationDFR()

BEGIN
  
   -- Insert new record in email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM form_field_info WHERE formAliasName='addrevaluationwin' and formFieldName='revaluationCode')) THEN
    
	INSERT INTO `form_field_info` 
	(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, 
	`formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
	VALUES ('addrevaluationwin', 'revaluationCode', 'revaluationCode', 'textfield', 0, 0, 1, now(), 'Revaluation Code', 'Revaluation Setup Form', 'Create and View and Edit', 'Revaluation Code', 0);


  END IF;
  
  IF NOT EXISTS ((SELECT * FROM form_field_info WHERE formAliasName='addrevaluationwin' and formFieldName='revaluationName')) THEN
    
	INSERT INTO `form_field_info` 
	(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, 
	`formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
	VALUES ('addrevaluationwin', 'revaluationName', 'revaluationName', 'textfield', 0, 0, 1, now(), 'Revaluation Name', 'Revaluation Setup Form', 'Create and View and Edit', 'Revaluation Name', 0);


  END IF;
  
   IF NOT EXISTS ((SELECT * FROM form_field_info WHERE formAliasName='addrevaluationwin' and formFieldName='maxRevalToApply')) THEN
    
	INSERT INTO `form_field_info` 
	(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, 
	`formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
	VALUES ('addrevaluationwin', 'maxRevalToApply', 'maxRevalToApply', 'numberfield', 0, 0, 1, now(), 'Max Course To Apply', 'Revaluation Setup Form', 'Create and View and Edit', 'Max Course To Apply', 0);


  END IF;
  
   IF NOT EXISTS ((SELECT * FROM form_field_info WHERE formAliasName='addrevaluationwin' and formFieldName='validTill')) THEN
    
	INSERT INTO `form_field_info` 
	(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, 
	`formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
	VALUES ('addrevaluationwin', 'validTill', 'validTill', 'datefield', 0, 0, 1, now(), 'Valid Till', 'Revaluation Setup Form', 'Create and View and Edit', 'Valid Till', 0);


  END IF;
  
  IF NOT EXISTS ((SELECT * FROM form_field_info WHERE formAliasName='addrevaluationwin' and formFieldName='isRevalFeeApplicable')) THEN
    
	INSERT INTO `form_field_info` 
	(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, 
	`formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
	VALUES ('addrevaluationwin', 'isRevalFeeApplicable', 'isRevalFeeApplicable', 'radiogroup', 0, 0, 1, now(), 'Whether Revaluation Fee Applicable', 'Revaluation Setup Form', 'Create and View and Edit', 'Whether Revaluation Fee Applicable', 0);


  END IF;
  
  IF NOT EXISTS ((SELECT * FROM form_field_info WHERE formAliasName='addrevaluationwin' and formFieldName='revalApplicableFor')) THEN
    
	INSERT INTO `form_field_info` 
	(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, 
	`formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
	VALUES ('addrevaluationwin', 'revalApplicableFor', 'revalApplicableFor', 'radiogroup', 0, 0, 1, now(), 'Revaluation Fee Applicable At', 'Revaluation Setup Form', 'Create and View and Edit', 'Revaluation Fee Applicable At', 0);


  END IF;

END $$

-- Execute the stored procedure
CALL V20200715160510__ExaminationRevaluationDFR() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200715160510__ExaminationRevaluationDFR $$
 
DELIMITER ;