DELIMITER $$

DROP PROCEDURE IF EXISTS V20200715204810__InsertUITransForPersonBirth $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200715204810__InsertUITransForPersonBirth()

BEGIN
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PERSON' and keyName='BIRTH_PLACE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PERSON','BIRTH_PLACE','Place of Birth','Place of Birth','Plek van geboorte', 'Nơi sinh',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PERSON' and keyName='BIRTH_PLACE_LANGUAGE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PERSON','BIRTH_PLACE_LANGUAGE','Place of Birth-Other Language','Place of Birth-Other Language','Geboorteplek - ander taal', 'Nơi sinh-Ngôn ngữ khác',now(),1);
 END IF;
 
END $$

-- Execute the stored procedure
CALL V20200715204810__InsertUITransForPersonBirth $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200715204810__InsertUITransForPersonBirth $$
 
DELIMITER ;