DELIMITER $$
DROP PROCEDURE IF EXISTS V20200716225219__Create_StudHostelDetails $$
CREATE PROCEDURE V20200716225219__Create_StudHostelDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_hostel_details')) THEN 
	
	CREATE TABLE `student_hostel_details` (
	  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	  `hostelId` BIGINT(20) NOT NULL,
	  `studentHostelRequirementId` BIGINT(20) NOT NULL,
	  `lastUpdatedBy` BIGINT(20) NOT NULL,
	  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	  PRIMARY KEY (`id`),
	  CONSTRAINT `fk_student_hostel_details_hostelId`
	    FOREIGN KEY (`hostelId`)
	    REFERENCES `hostel` (`id`)
	    ON DELETE NO ACTION
	    ON UPDATE NO ACTION,
	  CONSTRAINT `fk_student_hostel_details_lastUpdatedBy`
	    FOREIGN KEY (`lastUpdatedBy`)
	    REFERENCES `users` (`id`)
	    ON DELETE NO ACTION
	    ON UPDATE NO ACTION,
	  CONSTRAINT `fk_student_hostel_details_studentHostelRequirementId`
	    FOREIGN KEY (`studentHostelRequirementId`)
	    REFERENCES `student_hostel_requirement` (`id`)
	    ON DELETE NO ACTION
	    ON UPDATE NO ACTION
	 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;


END IF; 

END $$
CALL V20200716225219__Create_StudHostelDetails () $$ 
DROP PROCEDURE IF EXISTS V20200716225219__Create_StudHostelDetails $$ 
DELIMITER ;
