DELIMITER $$

DROP PROCEDURE IF EXISTS V20200717155340__InsertUITRNSForPortal $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200717155340__InsertUITRNSForPortal()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='APPLICATION_FEES')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','APPLICATION_FEES','Application Fee','Application Fee','Aansoek fooi', 'Phí đăng ký',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PAY_TYPE_ONLINE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','PAY_TYPE_ONLINE','Online Mode','Online Mode','Aanlyn-modus', 'Chế độ online',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PAY_TYPE_OFFLINE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','PAY_TYPE_OFFLINE','Offline Mode','Offline Mode','Vanlyn af', 'Chế độ ngoại tuyến',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PRINT_PROFILE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','PRINT_PROFILE','Print Profile','Print Profile','Drukprofiel', 'In hồ sơ',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PAYMENT_OPTION')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','PAYMENT_OPTION','Payment Options','Payment Options','Betaal opsies', 'Các lựa chọn thanh toán',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='NOTES_DECLARATION')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','NOTES_DECLARATION','Notes & Declaration','Notes & Declaration','Aantekeninge en verklaring', 'Ghi chú & Tuyên bố',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='I_AGREE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','I_AGREE','I Agree','I Agree','Ek stem saam', 'Tôi đồng ý',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='SUBJECT_ALREADY_ADDED')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','SUBJECT_ALREADY_ADDED','Subject already added please add other one', 'Subject already added please add other one', 'Onderwerp alreeds bygevoeg, voeg n ander een by', 'Chủ đề đã được thêm vào xin vui lòng thêm một chủ đề khác',now(),1);
 END IF;
 
 
END $$

-- Execute the stored procedure
CALL V20200717155340__InsertUITRNSForPortal $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200717155340__InsertUITRNSForPortal $$
 
DELIMITER ;