DELIMITER $$
DROP PROCEDURE IF EXISTS V20200724145617__Create_onlinePaymentTransactionDetails $$
CREATE PROCEDURE V20200724145617__Create_onlinePaymentTransactionDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='online_payment_transaction_details')) THEN 
CREATE TABLE `online_payment_transaction_details` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `applicationId` BIGINT NOT NULL,
  `transactionReference` VARCHAR(255) NOT NULL,
  `transactionPayURL` VARCHAR(255) NULL,
  `transactionDate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `paymentAmount` DOUBLE(20,2) NOT NULL,
  `status` VARCHAR(255) NOT NULL,
  `responseCode` VARCHAR(255) NULL,
  `responseMessage` VARCHAR(255) NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_online_payment_transaction_details_applicationId_idx` (`applicationId` ASC),
  INDEX `fk_online_payment_transaction_details_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_online_payment_transaction_details_applicationId`
    FOREIGN KEY (`applicationId`)
    REFERENCES `application` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_online_payment_transaction_details_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20200724145617__Create_onlinePaymentTransactionDetails () $$ 
DROP PROCEDURE IF EXISTS V20200724145617__Create_onlinePaymentTransactionDetails $$ 
DELIMITER ;