DELIMITER $$
DROP PROCEDURE IF EXISTS V20200728173943__Update_PrgWiseApplApproveTempData $$
CREATE PROCEDURE V20200728173943__Update_PrgWiseApplApproveTempData()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((select * from dydt_data_provider where providerName='Program Wise Application Approval Provider')) THEN

	SET @dydtdataproviderId=(SELECT id FROM dydt_data_provider WHERE `providerName`='Program Wise Application Approval Provider');
    UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT \n    T5.id AS ID,\n    T6.code AS APP_PROG_APPLICATION_CODE,\n    T7.firstName AS APP_PROG_FIRST_NAME,\n    T7.middleName AS APP_PROG_MIDDLE_NAME,\n    T7.lastName AS APP_PROG_LAST_NAME,\n    T7.printName AS APP_PROG_PRINT_NAME,\n    T7.emailId AS APP_PROG_EMAIL_ID,\n    T7.mobileNumber AS APP_PROG_MOBILE_NO,\n    T7.mobileCountryCode AS APP_PROG_MOBILE_CODE,\n    T8.displayName AS APP_PROG_DISPLAY_NAME,\n    T8.academyName AS APP_PROG_ACADEMY_NAME,\n    T9.addressText AS APP_PROG_ADDRESS_TEXT,\n    T20.websiteURL AS APP_WEBSITE_URL,\n    T9.pincode AS APP_PROG_PINCODE,\n    T11.cityName AS APP_PROG_CITY_NAME,\n    T12.countryName AS APP_PROG_COUNTRY_NAME,\n    T13.programCode AS APP_PROG_PROGRAM_CODE,\n    T13.programName AS APP_PROG_PROGRAM_NAME,\n    T16.itemValue AS APP_PROG_ITEM_VALUE,\n    T18.loginId AS APP_PROG_USER_NAME,\n    CONVERT( FROM_BASE64(T18.passwordBase64) USING utf8) AS APP_PASSWORD,\n    DATE_FORMAT(T22.admissionOfferStartDate, \'%d/%m/%Y\') AS ADMISSION_OFFER_START_DATE\nFROM\n    application_program T5\n        LEFT JOIN\n    application T6 ON T6.id = T5.applicationId\n        LEFT JOIN\n    applicant_person T7 ON T7.id = T6.applicantPersonId\n        LEFT JOIN\n    academy_location T8 ON T8.id = T5.academyLocationId\n        LEFT JOIN\n    applicant_address T9 ON T9.applicantPersonId = T7.id\n        and T9.whetherPrimary\n        and T9.addressTypeId = 5\n        LEFT JOIN\n    city T11 ON T11.id = T9.cityId\n        LEFT JOIN\n    country T12 ON T12.id = T9.countryId\n        LEFT JOIN\n    programs T13 ON T13.id = T5.programId\n        LEFT JOIN\n    prog_batch_seat_config T14 ON T14.id = T5.progBatchSeatConfigId\n        LEFT JOIN\n    batches T15 ON T15.id = T14.programBatchId\n        LEFT JOIN\n    intake_year T16 ON T16.id = T15.intakeYearId\n        LEFT JOIN\n    external_user_association T17 ON T17.applicationId = T6.id\n        LEFT JOIN\n    external_users T18 ON T18.id = T17.externalUserId\n        LEFT JOIN\n    academy_location_addresses T19 ON T19.academyLocationId = T5.academyLocationId\n        LEFT JOIN\n    address T20 ON T20.id = T19.addressId\n        and T20.addressTypeId = 10\nLEFT JOIN\n    program_selection_process T21 on T21.programBatchSeatConfigId = T5.progBatchSeatConfigId\n        LEFT JOIN\n    prog_slctn_process_admisn_conf T22 on T22.programSelectionProcessId = T21.id', `resultColumnsDef`='APP_PROG_APPLICATION_CODE,APP_PROG_FIRST_NAME,APP_PROG_MIDDLE_NAME,APP_PROG_LAST_NAME,APP_PROG_PRINT_NAME,APP_PROG_EMAIL_ID,APP_PROG_MOBILE_NO,APP_PROG_MOBILE_CODE,APP_PROG_DISPLAY_NAME,APP_PROG_ACADEMY_NAME,APP_PROG_ADDRESS_TEXT,APP_WEBSITE_URL,APP_PROG_PINCODE,APP_PROG_CITY_NAME,APP_PROG_COUNTRY_NAME,APP_PROG_PROGRAM_CODE,APP_PROG_PROGRAM_NAME,APP_PROG_ITEM_VALUE,APP_PROG_USER_NAME,APP_PASSWORD,ADMISSION_OFFER_START_DATE' where dataProviderId = @dydtdataproviderId and dataSourceCode = 'COMPLETE_ADMISSION_INPUT_PARAMETER';    

END IF; 

IF NOT EXISTS ((SELECT * FROM `dydt_templateparams_translations` WHERE translationCode = 'ADMISSION_OFFER_START_DATE')) THEN 

	SET @dydtdataproviderIdTemp=(SELECT id FROM dydt_data_provider WHERE `providerName`='Program Wise Application Approval Provider');
	
	IF EXISTS ((select * from dydt_data_line_item where dataProviderId = @dydtdataproviderIdTemp and dataSourceCode = 'COMPLETE_ADMISSION_INPUT_PARAMETER')) THEN
		SET @dydtdatalineitemId=(select id from dydt_data_line_item where dataProviderId = @dydtdataproviderIdTemp and dataSourceCode = 'COMPLETE_ADMISSION_INPUT_PARAMETER');
    	INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('ADMISSION_OFFER_START_DATE', 'Admission Offer Start Date',@dydtdatalineitemId);
	END IF;	

END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20200728173943__Update_PrgWiseApplApproveTempData () $$
DROP PROCEDURE IF EXISTS V20200728173943__Update_PrgWiseApplApproveTempData $$
DELIMITER ;