DELIMITER $$
DROP PROCEDURE IF EXISTS V20200817201321__Create_CreateGidelinesDocumentTable $$
CREATE PROCEDURE V20200817201321__Create_CreateGidelinesDocumentTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='guidlines_documents')) THEN 
CREATE TABLE `guidlines_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `dataReqSetupId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_guidlines_documents` (`documentId`),
  KEY `FK_data_requirement_setup` (`dataReqSetupId`),
  KEY `FK_guidelines_document_users` (`lastUpdatedBy`),
  CONSTRAINT `FK_data_requirement_setup` FOREIGN KEY (`dataReqSetupId`) REFERENCES `data_requirement_setup` (`id`),
  CONSTRAINT `FK_guidelines_document_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20200817201321__Create_CreateGidelinesDocumentTable () $$ 
DROP PROCEDURE IF EXISTS V20200817201321__Create_CreateGidelinesDocumentTable $$ 
DELIMITER ;