DELIMITER $$

DROP PROCEDURE IF EXISTS V20200821181119__Insert_UITranslation_IdentityExpiryDate $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200821181119__Insert_UITranslation_IdentityExpiryDate()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="PERSON" and keyName="IDENTITY_EXPIRY_DATE" )) THEN
    
	-- Insert Query 
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PERSON','IDENTITY_EXPIRY_DATE','Identity Expiry Date','Identity Expiry Date',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL V20200821181119__Insert_UITranslation_IdentityExpiryDate() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200821181119__Insert_UITranslation_IdentityExpiryDate $$
 
DELIMITER ;