DELIMITER $$

DROP PROCEDURE IF EXISTS V20200917201250__InsertUITranCatForPortal $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200917201250__InsertUITranCatForPortal()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='NO_RECORD_FOUND')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','NO_RECORD_FOUND','No Record Found','No Record Found', 'Geen rekord gevind nie','Không tìm thấy bản ghi',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='FIELD_OF_STUDY')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','FIELD_OF_STUDY','Field of Study','Field of Study', 'Studierigting','Chuyên ngành',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ENTRY_REQUIREMENT')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','ENTRY_REQUIREMENT','Entry Requirement','Entry Requirement', 'Toelatingsvereiste','Yêu cầu đầu vào',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='CERTIFICATE_TYPE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','CERTIFICATE_TYPE','Certificate Type','Certificate Type', 'Sertifikaat tipe','Loại chứng chỉ',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PRESENTATION_LANGUAGE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','PRESENTATION_LANGUAGE','Presentation Language','Presentation Language', 'Aanbiedingstaal','Ngôn ngữ trình bày',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='LATEST_YEAR_OFFERED')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','LATEST_YEAR_OFFERED','Latest Year Offered','Latest Year Offered', 'Laaste jaar aangebied','Năm mới nhất được cung cấp',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='READ_MORE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','READ_MORE','Read More','Read More', 'Lees meer','Đọc thêm',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='OFFERED_IN')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','OFFERED_IN','Offered in','Offered in', 'Aangebied in','Cung cấp trong',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PROGRAM_CATEGORY')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','PROGRAM_CATEGORY','Category','Category', 'Kategorie','Supply in',now(),1);
END IF;
 
END $$

-- Execute the stored procedure
CALL V20200917201250__InsertUITranCatForPortal $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200917201250__InsertUITranCatForPortal $$
 
DELIMITER ;