DELIMITER $$

DROP PROCEDURE IF EXISTS V20201008132801__InsertUITranCatForPortal $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20201008132801__InsertUITranCatForPortal()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DOWNLOAD_ALL')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','DOWNLOAD_ALL','Download All','Download All', 'Laai alles af','Tải xuống tất cả',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='CORE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','CORE','Core','Core', 'Kern','Cốt lõi',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ELECTIVE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','ELECTIVE','Elective','Elective', 'Keusevak','Tự chọn',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='CERTIFICATE_OF_ATTENDANCE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','CERTIFICATE_OF_ATTENDANCE','Certificate of Attendance','Certificate of Attendance', 'Sertifikaat van bywoning','Giấy chứng nhận tham dự',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='CERTIFICATE_OF_COMPETENCE')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','CERTIFICATE_OF_COMPETENCE','Certificate of Competence','Certificate of Competence', 'Sertifikaat van bekwaamheid','Chứng chỉ năng lực',now(),1);
END IF;

IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='MODULE_STRUCTURE')) THEN
UPDATE `ui_translation` SET `defaultValue`='Module Structure',
`customerDefineValue`='Module Structure',
`afriLanguage`='Module-struktuur',
`vietLanguage`='Cấu trúc mô-đun'
WHERE objectName='PORTAL_SETUP_NEW' and keyName='MODULE_STRUCTURE';
END IF;
 
END $$

-- Execute the stored procedure
CALL V20201008132801__InsertUITranCatForPortal $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20201008132801__InsertUITranCatForPortal $$
 
DELIMITER ;