DELIMITER $$
DROP PROCEDURE IF EXISTS V20201019184337__churchInformationCustomData $$
CREATE PROCEDURE V20201019184337__churchInformationCustomData()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='church_information_cd')) THEN 
CREATE TABLE `church_information_cd` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `church_information_id` int(11) DEFAULT NULL,
  `cf1` varchar(255) DEFAULT NULL,
  `cf2` varchar(255) DEFAULT NULL,
  `cf3` varchar(255) DEFAULT NULL,
  `cf4` varchar(255) DEFAULT NULL,
  `cf5` varchar(255) DEFAULT NULL,
  `cf6` varchar(255) DEFAULT NULL,
  `cf7` varchar(255) DEFAULT NULL,
  `cf8` varchar(255) DEFAULT NULL,
  `cf9` varchar(255) DEFAULT NULL,
  `cf10` varchar(255) DEFAULT NULL,
  `cf11` bigint(20) DEFAULT NULL,
  `cf12` bigint(20) DEFAULT NULL,
  `cf13` bigint(20) DEFAULT NULL,
  `cf14` date DEFAULT NULL,
  `cf15` date DEFAULT NULL,
  `cf16` tinyint(1) DEFAULT NULL,
  `cf17` tinyint(1) DEFAULT NULL,
  `cf18` varchar(255) DEFAULT NULL,
  `cf19` varchar(255) DEFAULT NULL,
  `version` bigint(20) NOT NULL,
  `lastupdatedBy` bigint(20) DEFAULT NULL,
  `lastupdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  CONSTRAINT `ref_church_information_cd_church_Information` FOREIGN KEY (`church_information_id`) REFERENCES `church_information` (`id`),
  CONSTRAINT `ref_church_information_cd_users` FOREIGN KEY (`lastupdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

SET SQL_SAFE_UPDATES=0;

IF EXISTS ((SELECT * FROM `applicant_portal_modules` WHERE module_code = 'STEP7_CHURCH_INFORMATION')) THEN 
update `applicant_portal_modules`
set table_name = 'church_information'
where module_code ='STEP7_CHURCH_INFORMATION';
END IF; 

SET SQL_SAFE_UPDATES=1;


INSERT INTO `custom_table_configs` (`displayName`,`tableName`,`customTableName`) 
VALUES ('Church Information','church_information','church_information_cd');

END $$
CALL V20201019184337__churchInformationCustomData () $$ 
DROP PROCEDURE IF EXISTS V20201019184337__churchInformationCustomData $$ 
DELIMITER ;