DELIMITER $$
DROP PROCEDURE IF EXISTS V20201022143658__Update_TriggersForParentGuardianPnC $$
CREATE PROCEDURE V20201022143658__Update_TriggersForParentGuardianPnC()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='sql_dtprovider' AND column_name='sqlQuery')) THEN 

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='GRADEBOOK_PUBLISH_PARENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`='SELECT 
    T1.id AS ID,
    T1.firstName AS FIRST_NAME,
    T1.lastName AS LAST_NAME,
    T1.printName AS PRINT_NAME,
    T1.emailId AS EMAIL_ID,
    T1.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T1.mobileNumber AS MOBILE_NO,
    T1.mobileCountryCode AS MOBILE_CODE,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T4.userId AS STUDENT_ID
FROM
    persons T1
        LEFT JOIN
    person_relationships T2 ON T2.relatedPersonId = T1.id
        LEFT JOIN
    persons T3 ON T3.id = T2.personId
        LEFT JOIN
    students T4 ON T4.personId = T3.id
        LEFT JOIN
    admission T5 ON T5.studentId = T4.userId
        LEFT JOIN
    academy_location T8 ON T8.id = T5.academyLocationId
WHERE (T1.isDeceased is null OR T1.isDeceased=FALSE) AND 
    T1.id IN (namedParams) AND T2.whetherDeleted = false' WHERE `dataProviderId`=@dtproviderId;
 
 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_DELETE_FOR_FATHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    sal.salutationName AS SALUTATION_NAME,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where ps.userId = f.userId)  AS DEVICE_ID,
	T1.reasonForSubstituteSession AS SUBSTITUTE_REASON,
    ml.code as LANGUAGE_KEY
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
      LEFT  JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
       LEFT JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    person_relationships AS pr ON pr.personId = T5.id
        INNER JOIN
    persons AS T7 ON T7.id = pr.relatedPersonId
  		LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	parents ps on ps.personId = T7.id
		LEFT JOIN
     multi_language ml on   T5.correspondence_language=ml.id
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
    T1.id IN (namedParams) AND pr.relationship = 'FATHER'  " WHERE `dataProviderId`=@dtproviderId;
    
    
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_DELETE_FOR_MOTHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    sal.salutationName AS SALUTATION_NAME,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where ps.userId = f.userId)  AS DEVICE_ID,
	T1.reasonForSubstituteSession AS SUBSTITUTE_REASON,
    ml.code as LANGUAGE_KEY
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
       LEFT JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
      LEFT  JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    person_relationships AS pr ON pr.personId = T5.id
        INNER JOIN
    persons AS T7 ON T7.id = pr.relatedPersonId
  		LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	parents ps on ps.personId = T7.id		
    LEFT JOIN
    multi_language ml on T5.correspondence_language =ml.id
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
    T1.id IN (namedParams) AND pr.relationship = 'MOTHER' " WHERE `dataProviderId`=@dtproviderId;
    

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_UPDATE_FOR_FATHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    oldp.firstName AS OLD_FACULTY_FIRST_NAME,
    oldp.lastName AS OLD_FACULTY_LAST_NAME,
    oldc.courseCodeToBePrinted AS OLD_COURSE_CODE,
    oldc.nameToBePrinted AS OLD_COURSE_NAME_TO_BE_PRINTED,
    oldr.resourceName AS OLD_ROOM_NAME,
    DATE_FORMAT(T1.oldSessionDate, '%d-%m-%Y') AS OLD_SESSION_DATE,
    DATE_FORMAT(T1.oldSlotFrom, '%h:%i %p') AS OLD_SLOT_FROM,
    DATE_FORMAT(T1.oldSlotTo, '%h:%i %p') AS OLD_SLOT_TO,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    sal.salutationName AS SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where ps.userId = f.userId)  AS DEVICE_ID
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
      LEFT  JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
       LEFT JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    person_relationships AS pr ON pr.personId = T5.id
        INNER JOIN
    persons AS T7 ON T7.id = pr.relatedPersonId
  		LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	parents ps on ps.personId = T7.id
    LEFT JOIN
    multi_language ml on T5.correspondence_language = ml.id
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
    T1.id IN (namedParams) AND pr.relationship = 'FATHER' " WHERE `dataProviderId`=@dtproviderId;
    

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_UPDATE_FOR_MOTHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    oldp.firstName AS OLD_FACULTY_FIRST_NAME,
    oldp.lastName AS OLD_FACULTY_LAST_NAME,
    oldc.courseCodeToBePrinted AS OLD_COURSE_CODE,
    oldc.nameToBePrinted AS OLD_COURSE_NAME_TO_BE_PRINTED,
    oldr.resourceName AS OLD_ROOM_NAME,
    DATE_FORMAT(T1.oldSessionDate, '%d-%m-%Y') AS OLD_SESSION_DATE,
    DATE_FORMAT(T1.oldSlotFrom, '%h:%i %p') AS OLD_SLOT_FROM,
    DATE_FORMAT(T1.oldSlotTo, '%h:%i %p') AS OLD_SLOT_TO,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    sal.salutationName AS SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where ps.userId = f.userId)  AS DEVICE_ID
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
       LEFT JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
      LEFT  JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    person_relationships AS pr ON pr.personId = T5.id
        INNER JOIN
    persons AS T7 ON T7.id = pr.relatedPersonId
  		LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	parents ps on ps.personId = T7.id
    LEFT JOIN
    multi_language ml on T5.correspondence_language=ml.id
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
    T1.id IN (namedParams) AND pr.relationship = 'MOTHER' " WHERE `dataProviderId`=@dtproviderId;
    

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_GUARDIAN_ABSENT_ONLY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false " WHERE `dataProviderId`=@dtproviderId;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20201022143658__Update_TriggersForParentGuardianPnC () $$
DROP PROCEDURE IF EXISTS V20201022143658__Update_TriggersForParentGuardianPnC $$
DELIMITER ;