DELIMITER $$
DROP PROCEDURE IF EXISTS V20201208165416__Insert_CreditFeeMappingTrans $$
CREATE PROCEDURE V20201208165416__Insert_CreditFeeMappingTrans()
BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='LIST_OF_PROGRAM')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','LIST_OF_PROGRAM','List of Program','List of Program','Programlys', 'Danh sách chương trình',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='SET_DEFAULT_AMOUNT')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','SET_DEFAULT_AMOUNT','Set Default Amount','Set Default Amount','Stel verstekbedrag', 'Đặt số tiền mặc định',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='AMOUNT_PER_CREDIT')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','AMOUNT_PER_CREDIT','Amount Per Credit','Amount Per Credit','Bedrag per krediet','Số tiền mỗi tín dụng', now(),1);
END IF;

SET SQL_SAFE_UPDATES=0;

IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MegaMenuConstants' and keyName='FEES_ACADEMICTERM_CREDITFEEMAPPING')) THEN 
UPDATE `ui_translation` SET `defaultValue`='Academic Term - Credit Fee Mapping',
`customerDefineValue`='Academic Term - Credit Fee Mapping',
`afriLanguage`='Akademiese termyn - Kredietgeldkaart',
`vietLanguage`='Học kỳ - Lập bản đồ phí tín dụng'
WHERE objectName='MegaMenuConstants' and keyName='FEES_ACADEMICTERM_CREDITFEEMAPPING';
END IF; 


SET SQL_SAFE_UPDATES=1;

END $$
CALL V20201208165416__Insert_CreditFeeMappingTrans () $$
DROP PROCEDURE IF EXISTS V20201208165416__Insert_CreditFeeMappingTrans $$
DELIMITER ;