DELIMITER $$

DROP PROCEDURE IF EXISTS V20201221095709__Insert_ApplicantEligibilityDetail $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20201221095709__Insert_ApplicantEligibilityDetail()

BEGIN
  
 IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='applicant_eligibility_detail' )) THEN
  
	CREATE TABLE `applicant_eligibility_detail` (
		`id` bigint NOT NULL AUTO_INCREMENT,
		`applicantPersonId` BIGINT NOT NULL,
		`achievementTypeId` BIGINT NULL,
		`achievementTypeOther` VARCHAR(100) NULL,
		`progEndorsedStatusId` BIGINT NULL,
		`additionalReqMet` BIT NULL,
		`heqsfLevelId` BIGINT NULL,
		`thirdYProgAvg` FLOAT NULL,
		`cognateSubAvg` FLOAT NULL,
		`honoursProgAvg` FLOAT NULL,
		`pgRequirementMet` BIT NULL,
		`pgMarks` BIT NULL,
		`honoursProgMastersAvg` FLOAT NULL,
		`mastersProgAvg` FLOAT NULL,
		`rpl` BIT NULL,
		`examNumber` BIGINT NULL,
		`examMonth` INT NULL,
		`examYear` INT NULL,
		`province` VARCHAR(10) NULL,
		`examBoard` VARCHAR(10) NULL,
		`centreNumber` BIGINT NULL,
		`centreName` VARCHAR(255) NULL,
		`attendanceMode` VARCHAR(45) NULL,
		`heAdmissionOriginal` VARCHAR(45) NULL,
		`heAdmissionCombined` VARCHAR(45) NULL,
		`numberOfSubject` INT NULL,
		`achievedNSC` BIT NULL,
		`eligibilityStatusId` BIGINT NULL,
		`comment` TEXT NULL,
		`lastUpdatedBy` BIGINT NOT NULL,
		`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		PRIMARY KEY (`id`),
		KEY `applicant_eligibility_applicantPersonId` (`applicantPersonId`),
		KEY `applicant_eligibility_achievementTypeId` (`achievementTypeId`),
		KEY `applicant_eligibility_progEndorsedStatusId` (`progEndorsedStatusId`),
		KEY `applicant_eligibility_heqsfLevelId` (`heqsfLevelId`),
		KEY `applicant_eligibility_eligibilityStatusId` (`eligibilityStatusId`),
		KEY `applicant_eligibility_lastUpdatedBy` (`lastUpdatedBy`),
		CONSTRAINT `applicant_eligibility_applicantPersonId` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
		CONSTRAINT `applicant_eligibility_achievementTypeId` FOREIGN KEY (`achievementTypeId`) REFERENCES `achievement_type` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
		CONSTRAINT `applicant_eligibility_progEndorsedStatusId` FOREIGN KEY (`progEndorsedStatusId`) REFERENCES `prog_endorsed_status` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
		CONSTRAINT `applicant_eligibility_heqsfLevelId` FOREIGN KEY (`heqsfLevelId`) REFERENCES `heqsf_level` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
		CONSTRAINT `applicant_eligibility_eligibilityStatusId` FOREIGN KEY (`eligibilityStatusId`) REFERENCES `eligibility_status` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
		CONSTRAINT `applicant_eligibility_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  END IF;
  
  -- insert ui translation for CSM dropdown value
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='ADMISSION' and keyName='APPLICANT_ELIGIBILITY_DETAIL')) THEN
		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('ADMISSION','APPLICANT_ELIGIBILITY_DETAIL','Applicant Eligibility Detail','Applicant Eligibility Detail','Aansoeker se geskiktheidsbesonderhede','Chi tiết về tính đủ điều kiện của ứng viên',now(),1);

	END IF;

END $$

-- Execute the stored procedure
CALL V20201221095709__Insert_ApplicantEligibilityDetail $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20201221095709__Insert_ApplicantEligibilityDetail $$
 
DELIMITER ;