DELIMITER $$
DROP PROCEDURE IF EXISTS V20201229153040__Insert_reportTemplate $$
CREATE PROCEDURE V20201229153040__Insert_reportTemplate()
BEGIN

IF NOT EXISTS ((select * from report_template where `templateCode`='STUDENT_RollList')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('16', 'STUDENT_RollList', 'Student Roll List', 'STUDENT_RollList.png', 'CommonReport_Excel.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'STUDENT_RollList.jasper', 'AcademiaLogo.png');
END IF; 


IF EXISTS ((select * from report_template where `templateCode`='STUDENT_RollList')) THEN 
set @templateId = (SELECT `id` FROM `report_template` WHERE `templateCode`='STUDENT_RollList');
INSERT INTO `report_template_translations` ( `reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdate`) 
VALUES (@templateId, 'TRANS_ACADEMIC_TERM', 'Academic term: ', NOW()),
(@templateId, 'TRANS_EXAM', 'EXAM: ', NOW()),
(@templateId, 'TRANS_SRNO', 'SR NO', NOW()),
(@templateId, 'TRANS_ROLL_NO', 'ROLL NO', NOW()),
(@templateId, 'TRANS_ENROLLMENT', 'ENROLMENT NO', NOW()),
(@templateId, 'TRANS_GENDER', 'GENDER', NOW()),
(@templateId, 'TRANS_CENTER', 'CENTER', NOW()),
(@templateId, 'TRANS_NAME', 'STUDENT NAME', NOW()),
(@templateId, 'TRANS_MOTHER_NAME', 'MOTHER NAME', NOW()),
(@templateId, 'TRANS_STUDENT_TYPE', 'STUDENT TYPE', NOW()),
(@templateId, 'TRANS_PROGRAM', 'PROGRAM', NOW()),
(@templateId, 'TRANS_BATCH', 'BATCH', NOW()),
(@templateId, 'TRANS_PERIOD', 'PERIOD', NOW()),
(@templateId, 'TRANS_SUBJECT', 'SUBJECT', NOW());
END IF; 

END $$
CALL V20201229153040__Insert_reportTemplate() $$
DROP PROCEDURE IF EXISTS V20201229153040__Insert_reportTemplate $$
DELIMITER ;