DELIMITER $$

DROP PROCEDURE IF EXISTS V20210113122120__InsertDFRForFeePayer $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20210113122120__InsertDFRForFeePayer()

BEGIN
  
  -- Insert new record in form_field_info table, if it doesn't already exist
  
IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'feepayerdetailform' and  formFieldName ='occupation')) THEN
	-- Insert Query 
	INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
	VALUES ('feepayerdetailform','occupation','occupationItemId','textfield',0,0,NULL,1,now(),'Occupation','1','Fee Payer Details','Create, Edit, and View','Occupation',0);
END IF;  

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'feepayerdetailform' and  formFieldName ='employerCompanyName')) THEN
	-- Insert Query 
	INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
	VALUES ('feepayerdetailform','employerCompanyName','employerCompanyNameItemId','textfield',0,0,NULL,1,now(),'Employer / Company Name','1','Fee Payer Details','Create, Edit, and View','Employer / Company Name',0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'feepayerdetailform' and  formFieldName ='employerEmail')) THEN
	-- Insert Query 
	INSERT INTO `form_field_info` (`formAliasName`,`formFieldName`,`formFieldId`,`formFieldInputType`,`isMandatory`,`isLocked`,`defaultValue`,`lastUpdatedBy`,`lastUpdate`,`formFieldDefaultLabel`,`formFieldDefaultHelpText`,`formScreenName`,`formScreenMode`,`fieldDisplayName`,`whetherForAllAcademyLocation`)
	VALUES ('feepayerdetailform','employerEmail','employerEmailItemId','textfield',0,0,NULL,1,now(),'Employer Email Address','1','Fee Payer Details','Create, Edit, and View','Employer Email Address',0);
END IF;


IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='fee_payer_detail'
 AND column_name ='occupation')) THEN
 
  ALTER TABLE `fee_payer_detail`  ADD COLUMN `occupation` VARCHAR(50) NULL DEFAULT NULL;
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='fee_payer_detail'
 AND column_name ='employerCompanyName')) THEN
 
  ALTER TABLE `fee_payer_detail`  ADD COLUMN `employerCompanyName` VARCHAR(50) NULL DEFAULT NULL;
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='fee_payer_detail'
 AND column_name ='employerEmail')) THEN
 
  ALTER TABLE `fee_payer_detail`  ADD COLUMN `employerEmail` VARCHAR(100) NULL DEFAULT NULL;
 END IF;
 

END $$

-- Execute the stored procedure
CALL V20210113122120__InsertDFRForFeePayer() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20210113122120__InsertDFRForFeePayer $$
 
DELIMITER ;