DELIMITER $$
DROP PROCEDURE IF EXISTS V20210129165258__Create_receipt_view_sapb1 $$
CREATE PROCEDURE V20210129165258__Create_receipt_view_sapb1()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='receipt_view_sapb1')) THEN 
CREATE VIEW receipt_view_sapb1 AS
  SELECT 
    rh.voucherMode AS VoucherType,
    rh.receiptType AS ReceiptMode,
    rh.receiptNo AS ReceiptNo,
    but.raiseBillType AS ReceiptType,
    but.billedUserType AS ReceiptFor,
    ou.code AS ReceivingIAU,
    c.currencyCode AS ReceivingCurrency,
    b.bankName AS OurBankAccount,
    rh.transactionDate AS ReceiptDate,
    (CASE
        WHEN (rh.applicantId IS NOT NULL) THEN CONCAT(a.code, '/', ap.printName)
        WHEN (rh.studentId IS NOT NULL) THEN CONCAT(st_user.code, '/', st_user.printName)
        WHEN (rh.sponsorId IS NOT NULL) THEN CONCAT(sp.sponsorshipCode, '/', sp.sponsorName)
        WHEN (rh.userId IS NOT NULL) THEN CONCAT(u.code, '/', u.printName)
        ELSE NULL
    END) AS ReceiptOwner,
    (CASE
        WHEN
            (rh.applicantId IS NOT NULL)
        THEN
            (SELECT 
                    pgmg.groupName
                FROM
                    program_group pgmg
                        LEFT JOIN
                    application app ON app.programGroupId = pgmg.id
                WHERE
                    app.id = a.id)
        WHEN
            (rh.studentId IS NOT NULL)
        THEN
            (SELECT 
                    pgmg.groupName
                FROM
                    program_group pgmg
                        LEFT JOIN
                    programs pgm ON pgmg.id = pgm.programGroupId
                        LEFT JOIN
                    admission adm ON adm.programId = pgm.id
                WHERE
                    adm.studentId = st.userId
                GROUP BY st.userId)
        ELSE NULL
    END) AS ProgramGroup,
    IFNULL(GROUP_CONCAT(fpm.paymentModeName
                SEPARATOR ','),
            NULL) AS PaymentMode,
    IFNULL(GROUP_CONCAT(rpr.instrumentNo
                SEPARATOR ','),
            NULL) AS InstrumentNo,
    IFNULL(GROUP_CONCAT(rpr.instrumentDate
                SEPARATOR ','),
            NULL) AS InstrumentDate,
    rpr.amount AS Amount,
    rpr.bankChargesAmount AS BankChargesAmount,
    rpr.bankChargesPercentage AS BankChargesPercentage,
    bdom.bankName AS DrawnOnBank,
    rh.narration AS Narration,
    (SELECT 
            GROUP_CONCAT(DISTINCT bh.billNo
                    SEPARATOR ',')
        FROM
            fee_adjustment_master fam
                LEFT JOIN
            fee_adjustment_details fad ON fam.id = fad.adjustmentMasterId
                LEFT JOIN
            bill_header bh ON bh.id = fad.billHeaderId
        WHERE
            fam.receiptHeaderId = rh.id
                AND fam.instrumentId = rpr.id) AS SettledDebitNote,
    (SELECT 
            GROUP_CONCAT(DISTINCT fpd.payerType
                    SEPARATOR ',')
        FROM
            fee_payer_detail fpd
        WHERE
            fpd.personId = p.id) AS FeePayerType,
    (SELECT 
            GROUP_CONCAT(DISTINCT fpd.companyName
                    SEPARATOR ',')
        FROM
            fee_payer_detail fpd
        WHERE
            fpd.personId = p.id) AS NameOfCompany,
    (SELECT 
            GROUP_CONCAT(DISTINCT fpd.firstName
                    SEPARATOR ',')
        FROM
            fee_payer_detail fpd
        WHERE
            fpd.personId = p.id) AS NameOfContactPerson,
    	(SELECT 
                GROUP_CONCAT(DISTINCT fpd.contactPerson
                        SEPARATOR ',')
            FROM
                fee_payer_detail fpd
            WHERE
                fpd.personId = p.id) AS NameOfCorporateContactPerson,
    (SELECT 
            GROUP_CONCAT(DISTINCT CONCAT(ad.addressText)
                    SEPARATOR '#')
        FROM
            fee_payer_detail fpd
                LEFT OUTER JOIN
            address ad ON ad.id = fpd.addressId
                LEFT OUTER JOIN
            city ci ON ci.id = ad.cityId
                LEFT OUTER JOIN
            country cou ON cou.id = ci.countryId
        WHERE
            fpd.personId = p.id
                AND fpd.addressId IS NOT NULL) AS Address,
    (SELECT 
            GROUP_CONCAT(DISTINCT fpd.companyAddress
                    SEPARATOR '#')
        FROM
            fee_payer_detail fpd
        WHERE
            fpd.personId = p.id) AS CompanyAddress,
    (SELECT 
            GROUP_CONCAT(DISTINCT fpd.corporateId
                    SEPARATOR ',')
        FROM
            fee_payer_detail fpd
        WHERE
            fpd.personId = p.id) AS CorporateId,
    rh.lastUpdate AS LastUpdate
FROM
    receipt_header rh
        LEFT JOIN
    receipt_payment_instrument rpr ON rpr.receiptHeaderId = rh.id
        LEFT JOIN
    users u ON rh.userId = u.id
        LEFT JOIN
    sponsors sp ON rh.sponsorId = sp.id
        LEFT JOIN
    application a ON rh.applicantId = a.id
        LEFT JOIN
    applicant_person ap ON a.applicantPersonId = ap.id
        LEFT JOIN
    students st ON st.userId = rh.studentId
        LEFT JOIN
    users st_user ON rh.studentId = st_user.id
        LEFT JOIN
    persons p ON p.id = st.personId
        LEFT JOIN
    billed_user_type but ON but.id = rh.receiptFor
        LEFT JOIN
    organization_units ou ON rh.iauId = ou.id
        LEFT JOIN
    currency c ON c.id = rh.currencyId
        LEFT JOIN
    bank b ON b.id = rh.depositedBank
        LEFT JOIN
    fee_payment_modes fpm ON fpm.id = rpr.paymentMode
        LEFT JOIN
    bank_drawn_on_master bdom ON bdom.id = rpr.instrumentBank
        LEFT JOIN
    bank_charges_history bch ON rpr.bankChargesHistoryId = bch.id
GROUP BY rh.id , rpr.id;
END IF; 

END $$
CALL V20210129165258__Create_receipt_view_sapb1 () $$ 
DROP PROCEDURE IF EXISTS V20210129165258__Create_receipt_view_sapb1 $$ 
DELIMITER ;
