DELIMITER $$
DROP PROCEDURE IF EXISTS V20210224143540__Create_FutureFeePayerDetail $$
CREATE PROCEDURE V20210224143540__Create_FutureFeePayerDetail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='future_fee_payer_detail')) THEN 
CREATE TABLE `future_fee_payer_detail` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `applicantPersonId` bigint DEFAULT NULL,
  `personId` bigint DEFAULT NULL,
  `payerType` varchar(15) DEFAULT NULL,
  `salutationId` bigint DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `middleName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `doesFeePayerConsentToCreditCheck` bit(1) DEFAULT NULL,
  `homeTelephoneCountryCode` varchar(10) DEFAULT NULL,
  `homeTelephone` varchar(20) DEFAULT NULL,
  `workTelephoneCountryCode` varchar(10) DEFAULT NULL,
  `workTelephone` varchar(45) DEFAULT NULL,
  `countryCode` varchar(10) DEFAULT NULL,
  `mobileNumber` varchar(20) DEFAULT NULL,
  `emailHome` varchar(100) DEFAULT NULL,
  `emailHomeUseForCommunication` bit(1) DEFAULT NULL,
  `emailWork` varchar(100) DEFAULT NULL,
  `emailWorkUseForCommunication` bit(1) DEFAULT NULL,
  `sponsorId` BIGINT DEFAULT NULL,
  `feePayerID` bigint DEFAULT NULL,
  `feePayerLatestPayslip` bigint DEFAULT NULL,
  `companyName` varchar(255) DEFAULT NULL,
  `contactPerson` varchar(255) DEFAULT NULL,
  `employeeOfOrganization` BIT(1) DEFAULT NULL,
  `employeeId` VARCHAR(255) DEFAULT NULL,
  `nationalAlternateId` VARCHAR(255) DEFAULT NULL,
  `paymentMode` VARCHAR(255) DEFAULT NULL,
  `debitOrderDate` VARCHAR(255) DEFAULT NULL,
  `accountType` VARCHAR(255) DEFAULT NULL,
  `accountNumber` VARCHAR(255) DEFAULT NULL,
  `accountName` VARCHAR(255) DEFAULT NULL,
  `bankId` BIGINT DEFAULT NULL,
  `branchCode` BIGINT DEFAULT NULL,
  `surname` VARCHAR(255) DEFAULT NULL,
  `companyAddress` VARCHAR(255) DEFAULT NULL,
  `addressId` BIGINT DEFAULT NULL,
  `debitOrderDateCSMId` BIGINT DEFAULT NULL,
  `corporateId` VARCHAR(255) DEFAULT NULL,
  `occupation` VARCHAR(50) DEFAULT NULL,
  `employerCompanyName` VARCHAR(50) DEFAULT NULL,
  `employerEmail` VARCHAR(100) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_future_fee_payer_detail_applicantPersonId_idx` (`applicantPersonId`),
  KEY `fk_future_fee_payer_detail_salutationId_idx` (`salutationId`),
  KEY `fk_future_fee_payer_detail_future_feePayerID_idx` (`feePayerID`),
  KEY `fk_future_fee_payer_detail_future_feePayerLatestPayslip_idx` (`feePayerLatestPayslip`),
  KEY `fk_future_fee_payer_detail_lastUpdateBy_idx` (`lastUpdatedBy`),
  KEY `fk_future_fee_payer_detail_personId_idx` (`personId`),
  KEY `fk_future_fee_payer_detail_sponsorId_idx` (`sponsorId`),
  KEY `fk_future_fee_payer_detail_banks` (`bankId`),
  KEY `future_fee_payer_detail_fk_addressId` (`addressId`),
  KEY `future_fee_payer_detail_fk_branchCode` (`branchCode`),
  KEY `fk_future_fee_payer_detail_debit_order_date_idx` (`debitOrderDateCSMId`),
  CONSTRAINT `fk_future_fee_payer_detail_applicantPersonId` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_future_fee_payer_detail_feePayerID` FOREIGN KEY (`feePayerID`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_future_fee_payer_detail_feePayerLatestPayslip` FOREIGN KEY (`feePayerLatestPayslip`) REFERENCES `documents` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_future_future_futurefee_payer_detail_lastUpdateBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_future_fee_payer_detail_personId` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_future_fee_payer_detail_salutationId` FOREIGN KEY (`salutationId`) REFERENCES `salutations` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_future_fee_payer_detail_sponsorId` FOREIGN KEY (`sponsorId`) REFERENCES `sponsors` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_future_fee_payer_detail_banks` FOREIGN KEY (`bankId`) REFERENCES `bank_drawn_on_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `future_fee_payer_detail_fk_branchCode` FOREIGN KEY (`branchCode`) REFERENCES `bank_drawn_child` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `future_fee_payer_detail_fk_addressId` FOREIGN KEY (`addressId`) REFERENCES `address` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_future_fee_payer_detail_debit_order_date` FOREIGN KEY (`debitOrderDateCSMId`) REFERENCES `debit_order_date` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
);
END IF; 

END $$
CALL V20210224143540__Create_FutureFeePayerDetail () $$ 
DROP PROCEDURE IF EXISTS V20210224143540__Create_FutureFeePayerDetail $$ 
DELIMITER ;