DELIMITER $$
DROP PROCEDURE IF EXISTS V20210225173503__Alter_ParentPaymentTermSettings $$
CREATE PROCEDURE V20210225173503__Alter_ParentPaymentTermSettings()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='parent_payment_term_settings' AND column_name='applicableForCurrentYear')) THEN 
ALTER TABLE `parent_payment_term_settings` 
ADD COLUMN `applicableForCurrentYear` BIT(1) NOT NULL AFTER `nextYearBursary`;

END IF; 


IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='parent_payment_term_settings' AND column_name='futureFeePayerDetail')) THEN 
ALTER TABLE `parent_payment_term_settings` 
ADD COLUMN `futureFeePayerDetail` BIGINT NULL DEFAULT NULL AFTER `feePayerDetail`,
ADD INDEX `RefParentPaymentTermSettingToFutureFeePayerDetail_idx` (`futureFeePayerDetail` ASC) VISIBLE;
 ALTER TABLE `parent_payment_term_settings` 
  ADD CONSTRAINT `RefParentPaymentTermSettingToFutureFeePayerDetail`
  FOREIGN KEY (`futureFeePayerDetail`)
  REFERENCES `future_fee_payer_detail` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
END IF; 

set sql_safe_updates=0;
IF EXISTS (SELECT * FROM `parent_payment_term_settings` WHERE applicableForCurrentYear=NULL) THEN
UPDATE `parent_payment_term_settings` SET `applicableForCurrentYear`=true;
END IF;
set sql_safe_updates=1;

END $$
CALL V20210225173503__Alter_ParentPaymentTermSettings() $$
DROP PROCEDURE IF EXISTS V20210225173503__Alter_ParentPaymentTermSettings $$
DELIMITER ;