DELIMITER $$
DROP PROCEDURE IF EXISTS V20210302122915__Insert_DFRForFitnessCertificate $$
CREATE PROCEDURE V20210302122915__Insert_DFRForFitnessCertificate()
BEGIN

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'fitnesscertificatewin' and formFieldId = 'certifiedBy' )) THEN 
INSERT INTO `form_field_info` 
(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, 
`formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
VALUES ('fitnesscertificatewin', 'certifiedBy', 'certifiedBy', 'textfield', 0, 0, 1, now(), 'Certified By', 
                           'Vehicle Fitness Certificate Details', 'Create, Edit, and View', 'Certified By', 0);
END IF; 


IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'fitnesscertificatewin' and formFieldId = 'issueDate' )) THEN 
INSERT INTO `form_field_info` 
(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, 
`formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
VALUES ('fitnesscertificatewin', 'issueDate', 'issueDate', 'datefield', 0, 0, 1, now(), 'Issue Date', 
                           'Vehicle Fitness Certificate Details', 'Create, Edit, and View', 'Issue Date', 0);
END IF; 

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'fitnesscertificatewin' and formFieldId = 'expirationDate' )) THEN 
INSERT INTO `form_field_info` 
(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, 
`formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
VALUES ('fitnesscertificatewin', 'expirationDate', 'expirationDate', 'datefield', 1, 0, 1, now(), 'Expiration Date', 
                           'Vehicle Fitness Certificate Details', 'Create, Edit, and View', 'Expiration Date', 0);
END IF; 


IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'fitnesscertificatewin' and formFieldId = 'vehicleFitCertificateDocument' )) THEN 
INSERT INTO `form_field_info` 
(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, 
`formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
VALUES ('fitnesscertificatewin', 'vehicleFitCertificateDocument', 'vehicleFitCertificateDocument', 'textfield', 1, 0, 1, now(), 'Fitness Certificate Document', 
                           'Vehicle Fitness Certificate Details', 'Create, Edit, and View', 'Fitness Certificate Document', 0);
END IF;

IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'fitnesscertificatewin' and formFieldId = 'vehicleFitCertificateUploadFile' )) THEN 
INSERT INTO `form_field_info` 
(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, 
`formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
VALUES ('fitnesscertificatewin', 'vehicleFitCertificateUploadFile', 'vehicleFitCertificateUploadFile', 'filefield', 1, 0, 1, now(), 'Select File', 
                           'Vehicle Fitness Certificate Details', 'Create, Edit, and View', 'Select File', 0);
END IF;

END $$
CALL V20210302122915__Insert_DFRForFitnessCertificate() $$
DROP PROCEDURE IF EXISTS V20210302122915__Insert_DFRForFitnessCertificate $$
DELIMITER ;
