DELIMITER $$
DROP PROCEDURE IF EXISTS V20210428142712__Create_studentApplyHolds $$
CREATE PROCEDURE V20210428142712__Create_studentApplyHolds()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_apply_hold_category')) THEN 
CREATE TABLE `student_apply_hold_category` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `holdCatId` BIGINT(20) NOT NULL,
  `subHoldCatId` BIGINT(20) DEFAULT NULL,
  `applyById` BIGINT(20) DEFAULT NULL,
  `removalById` BIGINT(20) DEFAULT NULL,
  `studentId` BIGINT(20) DEFAULT NULL,
  `isRemoval` BIT(1) DEFAULT NULL,
  `applyDate`  DATE  DEFAULT NULL,
  `removalDate`  DATE  DEFAULT NULL,
  `applyReason`  TEXT  DEFAULT NULL,
  `removalReason`  TEXT  DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
   INDEX `fk_student_apply_hold_category_holdCatId_idx` (`holdCatId` ASC),
   INDEX `fk_student_apply_hold_category_sub_holdCatId_idx` (`subHoldCatId` ASC),
   INDEX `fk_student_apply_hold_category_applyById_idx` (`applyById` ASC),
   INDEX `fk_student_apply_hold_category_removalById_idx` (`removalById` ASC),
   INDEX `fk_student_apply_hold_category_studentId_idx` (`studentId` ASC),
  INDEX `fk_student_apply_hold_category_users_id_idx` (`lastUpdatedBy` ASC),

  CONSTRAINT `fk_student_apply_hold_category_holdCatId_id`
    FOREIGN KEY (`holdCatId`)
    REFERENCES `manage_hold_category` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_student_apply_hold_category_sub_holdCatId_id`
    FOREIGN KEY (`subHoldCatId`)
    REFERENCES `manage_sub_hold_category` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_student_apply_hold_category_applyById_idx`
    FOREIGN KEY (`applyById`)
    REFERENCES `staffs` (`userId`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_student_apply_hold_category_removalById_id`
    FOREIGN KEY (`removalById`)
    REFERENCES `staffs` (`userId`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_student_apply_hold_category_studentId_id`
    FOREIGN KEY (`studentId`)
    REFERENCES `students` (`userId`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_student_apply_hold_category_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20210428142712__Create_studentApplyHolds () $$ 
DROP PROCEDURE IF EXISTS V20210428142712__Create_studentApplyHolds $$ 
DELIMITER ;