DELIMITER $$
DROP PROCEDURE IF EXISTS V20210511182336__Insert_SUBSpecialExamForm $$
CREATE PROCEDURE V20210511182336__Insert_SUBSpecialExamForm()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_type` WHERE typeName = 'Assessment Group Reports' )) THEN
INSERT INTO `report_type` (`typeName`) VALUES ('Assessment Group Reports'); 
END IF;


IF EXISTS (select max(id) from report_type where typeName='Assessment Group Reports') THEN
set  @special = (select max(id) from report_type where typeName='Assessment Group Reports');

IF NOT EXISTS (select * from report_template where `templateCode`='SUB_SPECIAL_EXAM_FORM') THEN
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)

VALUES (@special, 'SUB_SPECIAL_EXAM_FORM', 'SUB - Special Exam Form', 'SUB_SPECIAL_EXAM_FORM.png', 'SUB_EXAM_FORM_CommonReport.jasper', 'All', '1', 'Header_Excel_Blank.jasper', 'Header_Excel_Blank.jasper', '1', '1', 'SUB_SPECIAL_EXAM_FORM.jasper', 'AcademiaLogo.png');
END IF;


IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'SUB_SPECIAL_EXAM_FORM')) THEN 
set @form1 = (select max(id) from `report_template` WHERE templateCode = 'SUB_SPECIAL_EXAM_FORM');
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_CONSIDERATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_CONSIDERATION', 'Kindly consider me to appear in the following Special Exam papers Examinations.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_ENROLLMENT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_ENROLLMENT', 'Enrolment No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_DATEOFSUBMISSION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_DATEOFSUBMISSION', 'Last Date of Form Submission', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'STUDENT_NAME', 'Name of Student', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_FATHER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_FATHER_NAME', 'Father’s Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_SPECIAL_EXAM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_SPECIAL_EXAM', 'Special Exam Semester/year', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_COURSES')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_COURSES', 'Course & Branch', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_CONTACT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_CONTACT_NO', 'Contact No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_SUBJECT_DETAILS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_SUBJECT_DETAILS', 'The Subject details are as below-', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_SERIAL_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_SERIAL_NUM', 'Sr. No', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_PAPER_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_PAPER_CODE', 'Paper Code', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_PAPER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_PAPER_NAME', 'Name of Paper', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_PRESENT_GRADE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_PRESENT_GRADE', 'Present Grade\n(F/I)', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_ATTACH_BACK')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_ATTACH_BACK', '* Attach BACK Grade sheet with form compulsory', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_ATTACH_FEE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_ATTACH_FEE', '* Attach Fee Original Fee Receipt', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_DEPOSITE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_DEPOSITE', 'I have deposited Rs.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_DOT1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_DOT1', '………………………………………………', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_FOR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_FOR', 'for', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_DOT2')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_DOT2', '………………………………', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_NOS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_NOS', 'Nos. of Subjects', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_STUDENT_SIGNATURE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_STUDENT_SIGNATURE', 'Student Signature:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_FOR_OFFICE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_FOR_OFFICE', '(For Office Use Only)', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_EXAM_SECTION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_EXAM_SECTION', 'Exam Section', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_ACCOUNT_SECTION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_ACCOUNT_SECTION', 'Accounts Section', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_STD_ALLOWED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_STD_ALLOWED', 'Student is allowed for papers:', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_DOT3')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_DOT3', '………………………………', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_NOS_SUBJECT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_NOS_SUBJECT', 'Nos. of Subjects as per record.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_APPLICABLE_FEE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_APPLICABLE_FEE', 'Applicable Fee of Rs.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_DOT4')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_DOT4', '………………………………', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_NAME_SIGNATURE1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_NAME_SIGNATURE1', 'Name & Signature :', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_FEE_STATUS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_FEE_STATUS', 'Fee Status', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_DUE_FEE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_DUE_FEE', 'Total Fee due Rs.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form1 and keyValue='TRANS_NAME_SIGNATURE2')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form1, 'TRANS_NAME_SIGNATURE2', 'Name & Signature :', '1', now());
END IF;
END IF;


IF NOT EXISTS (select * from report_template where `templateCode`='SUB_BACK_EXAM_FORM') THEN
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)

VALUES (@special, 'SUB_BACK_EXAM_FORM', 'SUB - Back Exam Form', 'SUB_BACK_EXAM_FORM.png', 'SUB_EXAM_FORM_CommonReport.jasper', 'All', '1', 'Header_Excel_Blank.jasper', 'Header_Excel_Blank.jasper', '1', '1', 'SUB_BACK_EXAM_FORM.jasper', 'AcademiaLogo.png');
END IF;


IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'SUB_BACK_EXAM_FORM')) THEN 
set @form2 = (select max(id) from `report_template` WHERE templateCode = 'SUB_BACK_EXAM_FORM');

	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_CONSIDERATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_CONSIDERATION', 'Kindly consider me to appear in the following Back papers Examinations.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_DATEOFSUBMISSION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_DATEOFSUBMISSION', 'Last Date of Form Submission', '1', now());
END IF;
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_ODD_SEM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_ODD_SEM', 'ODD Semester', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_ENROLLMENT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_ENROLLMENT', 'Enrolment No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'STUDENT_NAME', 'Name of Student', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_FATHER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_FATHER_NAME', 'Father’s Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_SPECIAL_EXAM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_SPECIAL_EXAM', 'Back Semester/year', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_COURSES')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_COURSES', 'Course & Branch', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_CONTACT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_CONTACT_NO', 'Contact No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_SUBJECT_DETAILS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_SUBJECT_DETAILS', 'The Subject details are as below-', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_SERIAL_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_SERIAL_NUM', 'Sr. No', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_PAPER_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_PAPER_CODE', 'Paper Code', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_PAPER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_PAPER_NAME', 'Name of Paper', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_PRESENT_GRADE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_PRESENT_GRADE', 'Present Grade\n(E / F / I)', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_ATTACH_BACK')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_ATTACH_BACK', 'Attach BACK Grade sheet with form compulsory', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_DEPOSITE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_DEPOSITE', 'I have deposited Rs.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_DOT1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_DOT1', '………………………………………………', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_FOR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_FOR', 'for', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_DOT2')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_DOT2', '………………………………', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_NOS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_NOS', 'Nos. of Subjects', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_STUDENT_SIGNATURE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_STUDENT_SIGNATURE', 'Student Signature:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_FORWARDE_BY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_FORWARDE_BY', 'Forwarded by Dean /Dy. Dean', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_FOR_OFFICE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_FOR_OFFICE', '(For Office Use Only)', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_COE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_COE', '(COE)', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_EXAM_SECTION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_EXAM_SECTION', 'Exam Section', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_ACCOUNT_SECTION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_ACCOUNT_SECTION', 'Accounts Section', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_STD_ALLOWED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_STD_ALLOWED', 'Student is allowed for papers:', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_DOT3')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_DOT3', '………………………………', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_NOS_SUBJECT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_NOS_SUBJECT', 'Nos. of Subjects as per record.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_APPLICABLE_FEE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_APPLICABLE_FEE', 'Applicable Fee of Rs.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_DOT4')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_DOT4', '………………………………', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_NAME_SIGNATURE1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_NAME_SIGNATURE1', 'Name & Signature :', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_FEE_STATUS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_FEE_STATUS', 'Fee Status', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_DUE_FEE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_DUE_FEE', 'Total Fee due Rs.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form2 and keyValue='TRANS_NAME_SIGNATURE2')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form2, 'TRANS_NAME_SIGNATURE2', 'Name & Signature :', '1', now());
END IF;
END IF;


IF NOT EXISTS (select * from report_template where `templateCode`='SUB_IMPROVEMENT_EXAM_FORM') THEN
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)

VALUES (@special, 'SUB_IMPROVEMENT_EXAM_FORM', ' SUB - Improvement Exam Form', 'SUB_IMPROVEMENT_EXAM_FORM.png', 'SUB_EXAM_FORM_CommonReport.jasper', 'All', '1', 'Header_Excel_Blank.jasper', 'Header_Excel_Blank.jasper', '1', '1', 'SUB_IMPROVEMENT_EXAM_FORM.jasper', 'AcademiaLogo.png');
END IF;


IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'SUB_IMPROVEMENT_EXAM_FORM')) THEN 
set @form3 = (select max(id) from `report_template` WHERE templateCode = 'SUB_IMPROVEMENT_EXAM_FORM');
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_CONSIDERATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_CONSIDERATION', 'Kindly consider me to appear in the following Improvement papers Examinations.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_DATEOFSUBMISSION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_DATEOFSUBMISSION', 'Last Date of Form Submission', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'STUDENT_NAME', 'Name of Student', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_ENROLLMENT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_ENROLLMENT', 'Enrolment No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_FATHER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_FATHER_NAME', 'Father’s Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_IMPROVED_SEM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_IMPROVED_SEM', 'Improvement Semester/year', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_COURSES')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_COURSES', 'Course & Branch', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_CONTACT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_CONTACT_NO', 'Contact No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_SUBJECT_DETAILS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_SUBJECT_DETAILS', 'The Subject details are as below-', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_SERIAL_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_SERIAL_NUM', 'Sr. No', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_PAPER_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_PAPER_CODE', 'Paper Code', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_PAPER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_PAPER_NAME', 'Name of Paper', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_PRESENT_GRADE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_PRESENT_GRADE', 'Present Grade', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_ATTACH_BACK')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_ATTACH_BACK', '* Attach all previous Grade Sheet with form Compulsory', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_ATTACH_FEE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_ATTACH_FEE', '* Student will be allowed to repeat three courses (with all components) in the entire degree
programme.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_DEPOSITE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_DEPOSITE', 'I have deposited Rs.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_DOT1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_DOT1', '………………………………………………', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_FOR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_FOR', 'for', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_DOT2')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_DOT2', '………………………………', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_NOS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_NOS', 'Nos. of Subjects', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_STUDENT_SIGNATURE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_STUDENT_SIGNATURE', 'Student Signature:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_FORWARDE_BY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_FORWARDE_BY', 'Forwarded by Dean /Dy. Dean', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_ATTACHED_RECEIPT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_ATTACHED_RECEIPT', '(Attached Payment Receipt)', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_FOR_OFFICE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_FOR_OFFICE', '(For Office Use Only)', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_EXAM_SECTION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_EXAM_SECTION', 'Exam Section', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_ACCOUNT_SECTION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_ACCOUNT_SECTION', 'Accounts Section', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_STD_ALLOWED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_STD_ALLOWED', 'Student is allowed for papers:', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_DOT3')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_DOT3', '………………………………', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_NOS_SUBJECT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_NOS_SUBJECT', 'Nos. of Subjects as per record.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_APPLICABLE_FEE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_APPLICABLE_FEE', 'Applicable Fee of Rs.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_DOT4')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_DOT4', '………………………………', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_NAME_SIGNATURE1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_NAME_SIGNATURE1', 'Name & Signature :', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_FEE_STATUS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_FEE_STATUS', 'Fee Status', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_DUE_FEE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_DUE_FEE', 'Total Fee due Rs.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_NAME_SIGNATURE2')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_NAME_SIGNATURE2', 'Name & Signature :', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form3 and keyValue='TRANS_FEE_FOR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form3, 'TRANS_FEE_FOR', 'Fee for improvement per paper :', '1', now());
END IF;
END IF;

IF NOT EXISTS (select * from report_template where `templateCode`='SUB_REGULAR_EXAM_FORM') THEN
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)

VALUES (@special, 'SUB_REGULAR_EXAM_FORM', 'SUB - Regular Exam Form', 'SUB_SPECIAL_EXAM_FORM.png', 'SUB_EXAM_FORM_CommonReport.jasper', 'All', '1', 'Header_Excel_Blank.jasper', 'Header_Excel_Blank.jasper', '1', '1', 'SUB_REGULAR_EXAM_FORM.jasper', 'AcademiaLogo.png');
END IF;


IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'SUB_REGULAR_EXAM_FORM')) THEN 
set @form4 = (select max(id) from `report_template` WHERE templateCode = 'SUB_REGULAR_EXAM_FORM');
	

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_DATEOFSUBMISSION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_DATEOFSUBMISSION', 'Last Date of Form Submission', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'STUDENT_NAME', 'Name of Student', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_ENROLLMENT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_ENROLLMENT', 'Enrolment No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_FATHER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_FATHER_NAME', 'Father’s Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_MOTHER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_MOTHER_NAME', 'Mother Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_SEM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_SEM', 'Sem/year', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_DOB')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_DOB', 'Date of Birth', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_COURSES')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_COURSES', 'Course & Branch', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_CONTACT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_CONTACT_NO', 'Contact No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_SUBJECT_DETAILS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_SUBJECT_DETAILS', 'The Subject details are as below-', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_SERIAL_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_SERIAL_NUM', 'Sr. No', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_PAPER_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_PAPER_CODE', 'Paper Code', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_PAPER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_PAPER_NAME', 'Name of Paper', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_ATTACH_BACK')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_ATTACH_BACK', '* Attach 10th / 12th /Previous Semester Grade sheet with form compulsory', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_ATTACH_FEE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_ATTACH_FEE', '* Attach Fee Original Fee Receipt', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_DEPOSITE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_DEPOSITE', 'I have deposited Rs.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_DOT1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_DOT1', '………………………………………………', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_FOR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_FOR', 'for', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_DOT2')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_DOT2', '………………………………', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_NOS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_NOS', 'Nos. of Subjects', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_STUDENT_SIGNATURE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_STUDENT_SIGNATURE', 'Student Signature:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_FORWARDE_BY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_FORWARDE_BY', 'Forwarded by Dean/Dy. Dean', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_FOR_OFFICE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_FOR_OFFICE', '(For Office Use Only)', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_EXAM_SECTION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_EXAM_SECTION', 'Exam Section', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_ACCOUNT_SECTION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_ACCOUNT_SECTION', 'Accounts Section', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_STD_ALLOWED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_STD_ALLOWED', 'Student is allowed for papers:', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_DOT3')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_DOT3', '………………………………', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_NOS_SUBJECT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_NOS_SUBJECT', 'Nos. of Subjects as per record.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_APPLICABLE_FEE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_APPLICABLE_FEE', 'Applicable Fee of Rs.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_DOT4')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_DOT4', '………………………………', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_NAME_SIGNATURE1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_NAME_SIGNATURE1', 'Name & Signature :', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_FEE_STATUS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_FEE_STATUS', 'Fee Status', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_DUE_FEE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_DUE_FEE', 'Total Fee due Rs.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @form4 and keyValue='TRANS_NAME_SIGNATURE2')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@form4, 'TRANS_NAME_SIGNATURE2', 'Name & Signature :', '1', now());
END IF;
END IF;


END IF;
END $$
CALL V20210511182336__Insert_SUBSpecialExamForm() $$
DROP PROCEDURE IF EXISTS V20210511182336__Insert_SUBSpecialExamForm $$
DELIMITER ;