DELIMITER $$
DROP PROCEDURE IF EXISTS V20210512121346__Create_examConcessionDepField $$
CREATE PROCEDURE V20210512121346__Create_examConcessionDepField()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_concession_dependent_field' )) THEN 
CREATE TABLE `exam_concession_dependent_field` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `examConcessionId` BIGINT NOT NULL,
  `dependentFieldType`  VARCHAR(255) NOT NULL,
  `dependentFieldName`  VARCHAR(255) NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `examConcessionBatchMapping_lastUpdatedby` (`lastUpdatedBy` ASC) ,
  INDEX `examConcessiondependentfield_examConcessionId` (`examConcessionId` ASC) ,
  CONSTRAINT `exam_concession_df_lastUpdatedBy`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `exam_concession_df_examcancellationId`
	FOREIGN KEY (`examConcessionId`)
	REFERENCES `exam_concession` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20210512121346__Create_examConcessionDepField () $$ 
DROP PROCEDURE IF EXISTS V20210512121346__Create_examConcessionDepField $$ 
DELIMITER ;